% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate.R
\name{estimate}
\alias{estimate}
\alias{is_estimate}
\alias{as_estimate}
\title{Estimate class}
\usage{
estimate(x, se = NULL, moe = NULL, conf = 0.9)

is_estimate(x)

as_estimate(x)
}
\arguments{
\item{x}{A numeric vector containing the estimate(s).}

\item{se}{A numeric vector containing the standard error(s) for the
estimate(s). Users should supply either \code{se} or \code{moe} and \code{conf}.}

\item{moe}{A numeric vector containing the margin(s) of error. Users should
supply either \code{se} or \code{moe} and \code{conf}.}

\item{conf}{The confidence level to use in converting the margin of error to
a standard error. Defaults to 90\%, which is what the Census Bureau uses for
ACS estimates.}
}
\value{
An \code{estimate} vector.
}
\description{
A numeric vector that stores margin-of-error information along with it.
The margin of error will update through basic arithmetic operations, using a
first-order Taylor series approximation. The implicit assumption is that the
errors in each value are uncorrelated. If in fact there is correlation, the
margins of error could be wildly under- or over-estimated.
}
\examples{
estimate(5, 2) # 5 with std. error  2
estimate(15, moe=3) - estimate(5, moe=4)
estimate(1:4, 0.1) * estimate(1, 0.1)

}
