% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elc.R
\name{elc}
\alias{elc}
\title{Lorenz curve of education}
\usage{
elc(countries, init.y, final.y, database, M = 5000)
}
\arguments{
\item{countries}{character vector with the country codes of the countries
to be used. Some macro-regions are already defined and can be used
instead of the country codes: \code{South Asia, Europe and Central Asia,
Middle East and North Africa, Latin America and the Caribbean, Advanced
Economies, Sub-Saharan Africa, East Asia and the Pacific}.
(see \code{data_country}).}

\item{init.y}{the first year in which the function is calculated. Available
years are 1970, 1975, 1980, 1985, 1990, 1995, 2000, 2005, 2010.}

\item{final.y}{the last year in which the function is calculated Available
years are 1970, 1975, 1980, 1985, 1990, 1995, 2000, 2005, 2010.}

\item{database}{population subgrup for which the function is calculated.
The following options are available:
\enumerate{
  \item \code{"total15"}: Total population aged over-15.
  \item \code{"total25"}: Total population aged over-25.
  \item \code{"male15"}: Male population aged over-15.
  \item \code{"male25"}: Male population aged over-25.
  \item \code{"female15"}: Female population aged over-15.
  \item \code{"female25"}: Female population aged over-25.
}}

\item{M}{size of the simulated sample (default \code{M = 5000}).}
}
\value{
\code{elc} returns a graph of the evolution of the Lorenz curve of education
over the specified period.
}
\description{
\code{elc} is a function to graph the Lorenz curve of education for any group of
countries using the set of estimates developed in Jorda and Alonso (2017).
}
\details{
We use the set of estimates developed in Jorda and Alonso (2017), where
the generalized gamma distribution (Stacy, 1962) is used to model the time that
individuals attend school until they complete the educational cycle or decide to
drop out. To accommodate time and country varying parameters, the distribution of education
of each country and year is estimated by non-linear least squares (see, Jorda and
Alonso (2017) for further description on the estimation strategy).The Lorenz curve
is computed from a synthetic sample of size \code{M} of the distribution of
education of the specified group of countries.
The sample is obtained by Monte Carlo simulation using the mixture of the national
distributions, weighted by their population shares.
}
\examples{
elc(countries = c("CAN","USA"), init.y = 1985, final.y = 1985,
  database = "female25", M = 300)

}
\references{
Cowell, F. (2011). Measuring inequality. Oxford University Press.

Jorda, V. and Alonso, J.M. (2017). New estimates on educational
 attainment using a continuous approach (1970-2010), World Development,
 90, 281 - 293. \url{http://www.sciencedirect.com/science/article/pii/S0305750X16305010}

 Stacy, E. W. (1962). A generalization of the gamma distribution. Annals of
 Mathematical Statistics, 33, 1187 - 1192.
}
\seealso{
\code{\link[flexsurv]{GenGamma.orig}}, \code{\link[ineq]{Lc}},
  \code{\link{data_country}}. Visit \url{http://www.educationdata.unican.es}
  for more information on the constructoin of the dataset and the available
  \href{http://www.educationdata.unican.es/countries}{countries}.
}

