% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hllf.R
\docType{methods}
\name{logLik,hspec-method}
\alias{logLik,hspec-method}
\title{Compute the Log-Likelihood Function}
\usage{
\S4method{logLik}{hspec}(
  object,
  inter_arrival,
  type = NULL,
  mark = NULL,
  N = NULL,
  Nc = NULL,
  N0 = NULL,
  Nc0 = NULL,
  lambda_component0 = NULL,
  infer = FALSE,
  ...
)
}
\arguments{
\item{object}{An \code{\link{hspec-class}} object containing parameter values for computing the log-likelihood.}

\item{inter_arrival}{A vector of inter-arrival times for events across all dimensions, starting with zero.}

\item{type}{A vector indicating the dimensions, represented by numbers (1, 2, 3, etc.), starting with zero.}

\item{mark}{A vector of mark (jump) sizes, starting with zero.}

\item{N}{A matrix representing counting processes.}

\item{Nc}{A matrix of counting processes weighted by mark sizes.}

\item{N0}{A matrix of initial values for \code{N}.}

\item{Nc0}{A matrix of initial values for \code{Nc}.}

\item{lambda_component0}{Initial values for the lambda component \eqn{\lambda_{ij}}.
Can be a numeric value or a matrix.
Must have the same number of rows and columns as \code{alpha} or \code{beta} in \code{object}.}

\item{infer}{Logical}

\item{...}{Additional arguments passed to or from other methods.}
}
\description{
Calculates the log-likelihood for the Hawkes model.
}
\seealso{
\code{\link{hspec-class}}, \code{\link{hfit,hspec-method}}
}
