% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_json.R
\name{as_json}
\alias{as_json}
\title{Coerce an emld object into JSON}
\usage{
as_json(x, file = NULL)
}
\arguments{
\item{x}{an emld object}

\item{file}{optional path to write out to file.
Otherwise, defaults to NULL and will return a json object.}
}
\value{
a json object. Or if a file path is provided, the metadata
is written out in JSON file and the function returns \code{NULL} invisibly.
}
\description{
Coerce an emld object into JSON
}
\details{
Note: since emld list object maintains a 1:1 correspondence with JSON,
following the conventions of jsonlite, this function is basically trivial. The
only purpose is to default to auto_unbox = TRUE in serializing lists to JSON.
}
\examples{
f <- system.file("extdata/example.xml", package = "emld")
emld <- as_emld(f)
json <- as_json(emld)
## can also write a json file to disk:
json_file <- tempfile()
as_json(emld, json_file)
}
