% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_eurostat.R
\name{search_eurostat}
\alias{search_eurostat}
\title{Grep Datasets Titles from Eurostat}
\usage{
search_eurostat(
  pattern,
  type = "dataset",
  column = "title",
  fixed = TRUE,
  lang = "en"
)
}
\arguments{
\item{pattern}{Text string that is used to search from dataset, folder or table titles,
depending on the type argument.}

\item{type}{Selection for types of datasets to be searched. Default is \code{dataset}, other
possible options are \code{table}, \code{folder} and \code{all} for all types.}

\item{column}{Selection for the column of TOC where search is done. Default is \code{title},
other possible option is \code{code}.}

\item{fixed}{logical. If TRUE (default), pattern is a string to be matched as is.
See \code{grep()} documentation for more information.}

\item{lang}{2-letter language code, default is "\code{en}" (English), other
options are "\code{fr}" (French) and "\code{de}" (German). Used for labeling datasets.}
}
\value{
A tibble with nine columns:
\describe{
\item{title}{Dataset title in English (default)}
\item{code}{ Each item (dataset, table and folder) of the TOC has a
unique code which allows it to be identified in the API. Used in the
\code{\link[=get_eurostat]{get_eurostat()}} and \code{\link[=get_eurostat_raw]{get_eurostat_raw()}} functions to retrieve datasets.}
\item{type}{dataset, folder or table}
\item{last.update.of.data}{Date, indicates the last time the
dataset/table was updated (format \code{DD.MM.YYYY} or \verb{\%d.\%m.\%Y})}
\item{last.table.structure.change}{Date, indicates the last time the
dataset/table structure was modified (format \code{DD.MM.YYYY} or \verb{\%d.\%m.\%Y})}
\item{data.start}{Date of the oldest value included in the dataset
(if available) (format usually \code{YYYY} or \verb{\%Y} but can also be \code{YYYY-MM},
\code{YYYY-MM-DD}, \code{YYYY-SN}, \code{YYYY-QN} etc.)}
\item{data.end}{Date of the most recent value included in the dataset
(if available) (format usually \code{YYYY} or \verb{\%Y} but can also be \code{YYYY-MM},
\code{YYYY-MM-DD}, \code{YYYY-SN}, \code{YYYY-QN} etc.)}
\item{values}{Number of actual values included in the dataset}
\item{hierarchy}{Hierarchy of the data navigation tree, represented
in the original txt file by a 4-spaces indentation prefix in the title}
}
}
\description{
Lists datasets from eurostat table of contents with the
particular pattern in item titles.
}
\details{
Downloads list of all datasets available on
eurostat and return list of names of datasets that contains particular
pattern in the dataset description. E.g. all datasets related to
education of teaching.

If you wish to perform searches on other fields than item title,
you can download the Eurostat Table of Contents manually using
\code{get_eurostat_toc()} function and use \code{grep()} function normally. The data
browser on Eurostat website may also return useful results.
}
\section{Data source: Eurostat Table of Contents}{
The Eurostat Table of Contents (TOC) is downloaded from
\url{https://ec.europa.eu/eurostat/api/dissemination/catalogue/toc/txt?lang=en}
(default) or from French or German language variants:
\url{https://ec.europa.eu/eurostat/api/dissemination/catalogue/toc/txt?lang=fr}
\url{https://ec.europa.eu/eurostat/api/dissemination/catalogue/toc/txt?lang=de}

See Eurostat documentation on TOC items:
\url{https://wikis.ec.europa.eu/display/EUROSTATHELP/API+-+Detailed+guidelines+-+Catalogue+API+-+TOC}
}

\examples{
\dontshow{if (check_access_to_data()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
tmp <- search_eurostat("education")
head(tmp)
# Use "fixed = TRUE" when pattern has characters that would need escaping.
# Here, parentheses would normally need to be escaped in regex
tmp <- search_eurostat("Live births (total) by NUTS 3 region", fixed = TRUE)
}
\dontshow{\}) # examplesIf}
}
\references{
See \code{citation("eurostat")}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{Kindly cite the eurostat R package as follows:

  Lahti L., Huovari J., Kainu M., and Biecek P. (2017). Retrieval and
  analysis of Eurostat open data with the eurostat package. The R
  Journal 9(1), pp. 385-392. doi: 10.32614/RJ-2017-019

  Lahti, L., Huovari J., Kainu M., Biecek P., Hernangomez D., Antal D.,
  and Kantanen P. (2023). eurostat: Tools for Eurostat Open Data
  [Computer software]. R package version 4.0.0.
  https://github.com/rOpenGov/eurostat

To see these entries in BibTeX format, use 'print(<citation>,
bibtex=TRUE)', 'toBibtex(.)', or set
'options(citation.bibtex.max=999)'.
}\if{html}{\out{</div>}}

When citing data downloaded from Eurostat, see section "Citing Eurostat data"
in \code{\link[=get_eurostat]{get_eurostat()}} documentation.
}
\seealso{
\code{\link[=get_eurostat]{get_eurostat()}}, \code{\link[=search_eurostat]{search_eurostat()}}
}
\author{
Przemyslaw Biecek and Leo Lahti \href{mailto:ropengov-forum@googlegroups.com}{ropengov-forum@googlegroups.com}
}
\keyword{database}
\keyword{utilities}
