% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/content.R
\name{create_tree}
\alias{create_tree}
\title{Convert a statement into an evaluation tree}
\usage{
create_tree(
  text,
  singular_operators = NULL,
  binary_operators = NULL,
  valid_functions = NULL
)
}
\arguments{
\item{text}{the string/code/statement you want to parse.}

\item{singular_operators}{tokens of length 1 that operate on a right hand value. For example, the `-` token is an operator to negate a vector. \code{NULL} value will be replaced with \code{c("-", "!")}.}

\item{binary_operators}{tokens of any length that operate on a left and right hand values. For example, the `+` token is an operator that adds a left vector to a right vector. \code{NULL} value will be replaced with \code{c(",", "|", "&", "<=", "<", ">=", ">", "==", "!=", "+", "-", "*", "\%/\%", "/", "\%\%", "\%in\%", ":", "^")}. The order determines the precedence of the operators.}

\item{valid_functions}{tokens of any length that are prefixed on a parenthesis block and specify a function to run on the provided parameters within the block. For example, the `log` token will evaluate the logarithm value of the first parameter. Note named parameters are not support. \code{NULL} value will be replaced with \code{c("log", "c", "any", "all", "abs", "ifelse")}.}
}
\value{
a list of lists. In other words, a tree data structure made from lists.
}
\description{
function will break \code{text} into a list of lists.
}
\details{
See \code{vignette("Overview", package = "evalR")}
}
\examples{
x <- create_tree("2 * (3 + 5)")
str(x)
}
