% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combineMods.R
\name{combineMods}
\alias{combineMods}
\title{Combines state space blocks of an exDQLM}
\usage{
combineMods(m1, m2)
}
\arguments{
\item{m1}{List containing the first model to be combined.}

\item{m2}{List containing the second model to be combined.}
}
\value{
List containing the new combined state space model components.
}
\description{
The function combines two models into a single state space model for an exDQLM.
}
\examples{
trend.comp = polytrendMod(2,rep(0,2),10*diag(2))
seas.comp = seasMod(365,c(1,2,4),C0=10*diag(6))
model = combineMods(trend.comp,seas.comp)
# using dlm package
library(dlm)
model = combineMods(dlmModPoly(order=2,C0=10*diag(2)),dlmModTrig(365,2,C0=10*diag(4)))

}
