% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fEGarch_fit-plot.R
\name{autoplot,fEGarch_fit-method}
\alias{autoplot,fEGarch_fit-method}
\title{Plot Method for Fitting Step Results in the Style of ggplot2}
\usage{
\S4method{autoplot}{fEGarch_fit}(object, which = NULL, ...)
}
\arguments{
\item{object}{an object returned by the fitting functions of this package,
for example by \code{\link{fEGarch}}.}

\item{which}{various plots can be selected either via a keyword or a number;
enter \code{"returns"} or \code{1} to show a plot of the input training series;
enter \code{"means"} or \code{2} to show the
fitted conditional means; enter \code{"stand_deviations"} or \code{3} to show
the fitted conditional standard deviations;
use \code{"residuals"} or \code{4} to show the standardized residuals
following the fitted model;
the default is \code{which = NULL} which then lets you select a plot
interactively in the R console.}

\item{...}{no purpose and only implemented for compatibility.}
}
\value{
A ggplot2-graphic object is returned, i.e. an object of classes
\code{"gg"} and \code{"ggplot"}.
}
\description{
This is method for producing various plots of the decomposition results
returned by this package.
}
\details{
Create predefined standard plots of the estimation objects returned by the
\code{fEGarch} package.
Plots are created in the ggplot2 plot style. The type of plot can be chosen
either interactively from the console, or the argument \code{which} can be
used to directly  select the kind of plot to create (see also the description
of the argument \code{which}) within the function call.
}
\examples{
window.zoo <- get("window.zoo", envir = asNamespace("zoo"))
rt <- window.zoo(SP500, end = "2002-12-31")
# Pure conditional volatility model
spec <- fEGarch_spec()
model <- fEGarch(spec, rt)
autoplot(model, which = 3)

}
\author{
\itemize{
\item Dominik Schulz (Research Assistant) (Department of Economics, Paderborn
University), \cr
Author and Package Creator
}
}
