test_that("(Scaled) t-distribution function has proper 1st, 2nd and 3rd noncentralized moments", {
  # 1st moment
  expect_equal(
    vapply(
      X = 5:15,
      FUN = function(.x) {
        integrate(function(x, .x, dfun) {x * dfun(x, df = .x)}, lower = -Inf, upper = Inf, .x = .x, dfun = pdf_std_v1)[[1]]
      },
      FUN.VALUE = numeric(1)
    ),
    rep(0, 11)
  )
  # 2nd moment
  expect_equal(
    vapply(
      X = 5:15,
      FUN = function(.x) {
        integrate(function(x, .x, dfun) {x^2 * dfun(x, df = .x)}, lower = -Inf, upper = Inf, .x = .x, dfun = pdf_std_v1)[[1]]
      },
      FUN.VALUE = numeric(1)
    ),
    rep(1, 11)
  )
  # 3rd moment
  expect_equal(
    vapply(
      X = 5:15,
      FUN = function(.x) {
        integrate(function(x, .x, dfun) {x^3 * dfun(x, df = .x)}, lower = -Inf, upper = Inf, .x = .x, dfun = pdf_std_v1)[[1]]
      },
      FUN.VALUE = numeric(1)
    ),
    rep(0, 11)
  )
})
test_that("(Scaled) t-distribution function returns values as expected", {
  # Check values for different dfs
  expect_equal(
    lapply(
      X = 5:15,
      FUN = function(.x) {
        c(pdf_std_v1(c(-1.96, -1, -0.5, -0.25, 0, 0.25, 0.5, 1, 1.96), .x))
      }
    ),
    list(c(0.0413189197579944, 0.206748335783172, 0.385453428933943,
0.460674002631079, 0.490070129263815, 0.460674002631079, 0.385453428933943,
0.206748335783172, 0.0413189197579944), c(0.0444359891744475,
0.21466252583998, 0.379131610071044, 0.443991280803188, 0.46875,
0.443991280803188, 0.379131610071044, 0.21466252583998, 0.0444359891744475
), c(0.0465877426592917, 0.219679797350981, 0.374764035797424,
0.433445976481118, 0.455528027786993, 0.433445976481118, 0.374764035797424,
0.219679797350981, 0.0465877426592917), c(0.0481645352461452,
0.223142290916526, 0.37158912, 0.426177174078005, 0.44652156769485,
0.426177174078005, 0.37158912, 0.223142290916526, 0.0481645352461452
), c(0.0493703644044565, 0.225674920275457, 0.369184279558803,
0.420863176300727, 0.439990229522591, 0.420863176300727, 0.369184279558803,
0.225674920275457, 0.0493703644044565), c(0.0503226375566653,
0.227607580145303, 0.367302434103521, 0.416808936128505, 0.435036398581567,
0.416808936128505, 0.367302434103521, 0.227607580145303, 0.0503226375566653
), c(0.0510938368336762, 0.229130733339631, 0.365790943440818,
0.413613997408406, 0.431149898746298, 0.413613997408406, 0.365790943440818,
0.229130733339631, 0.0510938368336762), c(0.0517311768292722,
0.230361989229139, 0.364550878036376, 0.411031368207394, 0.428019222362634,
0.411031368207394, 0.364550878036376, 0.230361989229139, 0.0517311768292722
), c(0.052266750381128, 0.231377878783378, 0.363515472297196,
0.408900434125629, 0.42544337133457, 0.408900434125629, 0.363515472297196,
0.231377878783378, 0.052266750381128), c(0.0527231413479352,
0.232230341024389, 0.362638105304858, 0.407112235095954, 0.423286830658312,
0.407112235095954, 0.362638105304858, 0.232230341024389, 0.0527231413479352
), c(0.0531167070200418, 0.23295586252626, 0.361885267820648,
0.405590245943651, 0.421454903679294, 0.405590245943651, 0.361885267820648,
0.23295586252626, 0.0531167070200418))
  )

  # Check symmetry once again numerically for different dfs
  expect_equal(
  lapply(
    X = 5:15,
    FUN = function(.x) {
      pdf_std_v1(c(-1.96, -1, -0.5, -0.25, -0.1), df = .x)
    }
  ),
  lapply(
    X = 5:15,
    FUN = function(.x) {
      pdf_std_v1(c(1.96, 1, 0.5, 0.25, 0.1), df = .x)
    }
  )
  )

})

#------------------------------------------------------

test_that("Check likelihood function for (scaled) t-distr.", {
  expect_equal(
  lapply(
    X = 5:15,
    FUN = function(.x) {
      c(pdf_std(c(-1.96, -1.5, -1, -0.5, -0.25, 0, 0.25, 0.5, 1, 1.5, 1.96),
              mu = rep(0.05, 11), sigt = rep(0.5, 11), df = .x))
    }
  ),
list(c(0.00376216880488244, 0.013197957706852, 0.0650425213382024,
0.354654687668324, 0.697644476106697, 0.970403837417987, 0.83866929708673,
0.478494626506679, 0.0916320944847725, 0.0178153787098604, 0.00486045267495043
), c(0.0032616265960907, 0.012902617057193, 0.0695657162117684,
0.37174849116106, 0.693391532077528, 0.929342806947264, 0.817249359442775,
0.491669738239137, 0.0987040441936717, 0.0178229673209297, 0.00433019202681871
), c(0.00284007379333802, 0.0124975318644376, 0.072621735394904,
0.382876503967819, 0.689867932216611, 0.903803904111212, 0.803204827331938,
0.499712930010857, 0.10361258541212, 0.017607999007247, 0.00386433315652321
), c(0.00249720321084922, 0.0120848148062324, 0.0748212191571682,
0.3907008643259, 0.6870621796371, 0.886375899722319, 0.793304391627033,
0.505115923499999, 0.107225435476044, 0.0173206884309985, 0.00347433521112247
), c(0.00221938654875314, 0.0116980929026673, 0.076477733071465,
0.396503881149415, 0.684816406868004, 0.873721732977006, 0.785955788413208,
0.50898860415879, 0.109998384986347, 0.0170196268757609, 0.00315107429980879
), c(0.00199286489978975, 0.0113468172771429, 0.0777688578695843,
0.400979853669037, 0.682992592007157, 0.864115271805012, 0.780287493293063,
0.511897516835079, 0.112194950305218, 0.0167283583527272, 0.00288242151974632
), c(0.00180637574558365, 0.0110315135294665, 0.0788026230202149,
0.404537594994811, 0.681488055492562, 0.856573422022123, 0.775783429095042,
0.5141611952194, 0.113978469585096, 0.0164558649313301, 0.00265754485440949
), c(0.00165121945934781, 0.0107495159999873, 0.0796484619913817,
0.407433549474818, 0.680228555177677, 0.850495001791606, 0.7721188721805,
0.515972147300297, 0.115455720405706, 0.0162047988319059, 0.00246767139992485
), c(0.00152078360420647, 0.0104972275311291, 0.080352997468632,
0.40983675632207, 0.679160209494339, 0.84549164521527, 0.769079421639337,
0.517453429866946, 0.116699512466811, 0.0159750345288771, 0.00230591581696424
), c(0.00141004493386819, 0.0102710145931231, 0.0809486741707464,
0.411863177552544, 0.678243385820583, 0.841301265851268, 0.766517873098947,
0.51868731234332, 0.117761227765848, 0.0157652754283358, 0.00216691854886359
), c(0.00131516459637864, 0.0100675414562693, 0.0814587528100708,
0.41359502103843, 0.677448460649153, 0.837740579615252, 0.764329833090931,
0.519730850568318, 0.118678176787917, 0.0155737997806669, 0.00204650168847468
))
)
})
