% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{FamilySmoking}
\alias{FamilySmoking}
\title{Family smoking}
\format{
A data frame with 5375 observations on the following 2 variables.
\describe{ 
\item{student}{ a factor with levels \code{DoesNotSmoke} \code{Smokes}} 
\item{parents}{ a factor with levels
\code{NeitherSmokes} \code{OneSmokes}} \code{BothSmoke} }
}
\source{
S. V. Zagona (ed.), \emph{Studies and issues in smoking behavior},
University of Arizona Press, 1967.
}
\description{
A cross-tabulation of whether a student smokes and how many of his or her
parents smoke from a study conducted in the 1960's.
}
\examples{

data(FamilySmoking)
xchisq.test( tally(parents ~ student, data = FamilySmoking) )

}
\references{
The data also appear in

Brigitte Baldi and David S. Moore, \emph{The Practice of Statistics in the
Life Sciences}, Freeman, 2009.
}
\keyword{datasets}
