% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05_GRaster_functions_by_layer.r
\name{is.na,GRaster-method}
\alias{is.na,GRaster-method}
\alias{is.na}
\alias{not.na,GRaster-method}
\alias{not.na}
\alias{abs,GRaster-method}
\alias{abs}
\alias{sin,GRaster-method}
\alias{sin}
\alias{cos,GRaster-method}
\alias{cos}
\alias{tan,GRaster-method}
\alias{tan}
\alias{asin,GRaster-method}
\alias{asin}
\alias{acos,GRaster-method}
\alias{acos}
\alias{atan,GRaster-method}
\alias{atan}
\alias{atan2,GRaster,GRaster-method}
\alias{atan2}
\alias{exp,GRaster-method}
\alias{exp}
\alias{log1p,GRaster-method}
\alias{log1p}
\alias{log10p,GRaster-method}
\alias{log10p}
\alias{log,GRaster-method}
\alias{log}
\alias{ln,GRaster-method}
\alias{ln}
\alias{log2,GRaster-method}
\alias{log2}
\alias{log10,GRaster-method}
\alias{log10}
\alias{sqrt,GRaster-method}
\alias{sqrt}
\alias{round,GRaster-method}
\alias{round}
\alias{floor,GRaster-method}
\alias{floor}
\alias{ceiling,GRaster-method}
\alias{ceiling}
\alias{trunc,GRaster-method}
\alias{trunc}
\title{Mathematical operations on each layer of a GRasters}
\usage{
\S4method{is.na}{GRaster}(x)

\S4method{not.na}{GRaster}(x, falseNA = FALSE)

\S4method{abs}{GRaster}(x)

\S4method{sin}{GRaster}(x)

\S4method{cos}{GRaster}(x)

\S4method{tan}{GRaster}(x)

\S4method{asin}{GRaster}(x)

\S4method{acos}{GRaster}(x)

\S4method{atan}{GRaster}(x)

\S4method{atan2}{GRaster,GRaster}(y, x)

\S4method{exp}{GRaster}(x)

\S4method{log1p}{GRaster}(x)

\S4method{log10p}{GRaster}(x)

\S4method{log}{GRaster}(x, base = exp(1))

\S4method{ln}{GRaster}(x)

\S4method{log2}{GRaster}(x)

\S4method{log10}{GRaster}(x)

\S4method{sqrt}{GRaster}(x)

\S4method{round}{GRaster}(x, digits = 0)

\S4method{floor}{GRaster}(x)

\S4method{ceiling}{GRaster}(x)

\S4method{trunc}{GRaster}(x)
}
\arguments{
\item{x, y}{\code{GRaster}s.}

\item{falseNA}{Logical (function \code{not.na()}): If \code{FALSE} (default), non-\code{NA} cells will be converted to 1, and \code{NA} cells to 0. If \code{TRUE}, non-\code{NA} cells will be converted to  and \code{NA} cells will stay as \code{NA}.}

\item{base}{Numeric: Base of the logarithm.}

\item{digits}{Numeric: Number of digits to round to. If negative, then rounding is to the nearest positive power of 10. For example, if \code{digits = -2}, then the \code{GRaster} values are rounded to the nearest 100.}
}
\value{
A \code{GRaster}.
}
\description{
You can apply mathematical functions to each layer of a \code{GRaster}. The output is a \code{GRaster} with the same number or layers as the input. Available functions include:\cr
\itemize{
\item \code{NA}s:
\itemize{
\item \code{is.na()}
\item \code{not.na()}
}
\item Absolute value: \code{abs()}
\item Trigonometric functions (assumes values are in radians):
\itemize{
\item \code{cos()}
\item \code{sin()}
\item \code{tan()}
\item \code{acos()}
\item \code{asin()}
\item \code{atan()}
\item \code{atan2()}
}
\item Exponential and logarithmic functions:
\itemize{
\item \code{exp()}
\item \code{log()} (natural log)
\item \code{ln()} (also natural log)
\item \code{log2()} (log, base 2)
\item \code{log10()} (log, base 10)
\item \code{log1p()} (same as \code{log(x + 1)})
\item \code{log10p()} (same as \code{log(x + 1, base = 10)})
}
\item Power functions:
\itemize{
\item \code{sqrt()}
\item \code{x^y}
}
\item Rounding:
\itemize{
\item \code{round()}
\item \code{floor()} (round down)
\item \code{ceiling()} (round up)
\item \code{trunc()} (remove decimal portion)
}
}
}
\examples{
if (grassStarted()) {

# Setup
library(sf)
library(terra)

# Example data
madElev <- fastData("madElev")

# Convert a SpatRaster to a GRaster
elev <- fast(madElev)
elevs <- c(elev, elev, log10(elev) - 1, sqrt(elev))
names(elevs) <- c("elev1", "elev2", "log_elev", "sqrt_elev")

elev
elevs

# do some math
elev + 100
elev - 100
elev * 100
elev / 100
elev ^ 2
elev \%/\% 100 # divide then round down
elev \%\% 100 # modulus

100 + elev
100 \%/\% elev
100 \%\% elev

elevs + 100
100 + elevs

# math with logicals
elev + TRUE
elev - TRUE
elev * TRUE
elev / TRUE
elev ^ TRUE
elev \%/\% TRUE # divide then round down
elev \%\% TRUE # modulus

elevs + TRUE
TRUE + elevs

# Raster interacting with raster(s):
elev + elev
elev - elev
elev * elev
elev / elev
elev ^ log(elev)
elev \%/\% sqrt(elev) # divide then round down
elev \%\% sqrt(elev) # modulus

elevs + elev
elev * elevs

# sign
abs(-1 * elev)
abs(elevs)

# powers
sqrt(elevs)

# trigonometry
sin(elev)
cos(elev)
tan(elev)

asin(elev)
acos(elev)
atan(elev)

atan(elevs)
atan2(elev, elev^1.2)
atan2(elevs, elev^1.2)
atan2(elev, elevs^1.2)
atan2(elevs, elevs^1.2)

# logarithms
exp(elev)
log(elev)
ln(elev)
log2(elev)
log1p(elev)
log10(elev)
log10p(elev)
log(elev, 3)

log(elevs)

# rounding
round(elev + 0.5)
floor(elev + 0.5)
ceiling(elev + 0.5)
trunc(elev + 0.5)

}
}
