% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotRGB.r
\name{plotRGB,GRaster-method}
\alias{plotRGB,GRaster-method}
\alias{plotRGB}
\title{Create red-green-blue plot from a raster with RGB layers}
\usage{
\S4method{plotRGB}{GRaster}(x, r = 1, g = 2, b = 3, a = NULL, simplify = TRUE, ...)
}
\arguments{
\item{x}{A \code{GRaster}. Values must be in the range from 0 to 255.}

\item{r, g, b}{Either a numeric integer or the \code{\link[=names]{names()}} of layers representing red, green, and blue components.}

\item{a}{Either \code{NULL} (default), or a numeric integer or the \code{\link[=names]{names()}} of a layer representing transparency.}

\item{simplify}{Logical: If \code{TRUE} (default), then downsample the \code{GRaster} before plotting. This can save time for very dense rasters.}

\item{...}{Arguments to pass to \code{\link[terra:plotRGB]{terra::plotRGB()}}.}
}
\value{
Nothing (makes a plot).
}
\description{
This function takes as its main argument a \code{GRaster} with at least three layers typically representing red, green, and blue components (plus possibly an "alpha", or transparency layer). As with \code{\link[=plot]{plot()}}, this function is somewhat of a hack in that it downsamples the layers to a coarser resolution using \code{\link[=aggregate]{aggregate()}}, saves the raster to disk, then uses \code{\link[terra:plotRGB]{terra::plotRGB()}} to do the actual plotting.
}
\examples{
if (grassStarted()) {

# Example data
madElev <- fastData("madElev") # elevation raster
madLANDSAT <- fastData("madLANDSAT") # multi-layer raster
madRivers <- fastData("madRivers") # lines vector

# Convert SpatRaster to GRaster and SpatVector to GVector
elev <- fast(madElev)
rivers <- fast(madRivers)
landsat <- fast(madLANDSAT)

# Plot:
plot(elev)
plot(rivers, add = TRUE)

# Histograms:
hist(elev)
hist(landsat)

# Plot surface reflectance in RGB:
plotRGB(landsat, 3, 2, 1) # "natural" color
plotRGB(landsat, 4, 1, 2, stretch = "lin") # emphasize near-infrared (vegetation)

# Make composite map from RGB layers and plot in grayscale:
comp <- compositeRGB(r = landsat[[3]], g = landsat[[2]], b = landsat[[1]])
grays <- paste0("gray", 0:100)
plot(comp, col = grays)

}
}
\seealso{
\code{\link[terra:plotRGB]{terra::plotRGB()}}, \code{\link[=plot]{plot()}}, \code{\link[=compositeRGB]{compositeRGB()}}
}
