% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finnishgrid.R
\name{electricity_production_forecast_FI_DA}
\alias{electricity_production_forecast_FI_DA}
\title{Electricity production prediction - premilinary}
\usage{
electricity_production_forecast_FI_DA(
  start_time_utc = NA,
  end_time_utc = NA,
  user_key = NA
)
}
\arguments{
\item{start_time_utc}{Start time in UTC. Character array YYYY-MM-ddTHH:mm:ss.sssZ}

\item{end_time_utc}{End time in UTC. Character array YYYY-MM-ddTHH:mm:ss.sssZ}

\item{user_key}{Character array holding API-key.
Free from https://data.fingrid.fi/en/instructions}
}
\value{
A data frame object with time series data having period 15 min and unit type MWh/h.
}
\description{
15 minutes electricity generation forecast is based on the production plans that balance responsible parties have reported to Fingrid. The forecast is published daily by 6.00 pm for the next day, and it is not updated to match the updated production plans that balance responsible parties send to Fingrid. The Data before 10.06.2023 is in hourly resolution.
}
\examples{
\dontrun{
library(finnishgrid)
start = "2024-06-01T00:00:00.000Z"  # UTC
end = "2024-06-03T00:00:00.000Z"    # UTC
key = "MY_SUPER_SECRET"
df <- electricity_production_forecast_FI_DA(start_time_utc = start,
         end_time_utc = end,
         user_key = key)
summary(df)
}
}
\seealso{
https://data.fingrid.fi/en/datasets/242
}
