% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bhattacharya_method.R
\name{pathB_options}
\alias{pathB_options}
\title{Options controlling the path-integral algorithm}
\usage{
pathB_options(
  vf,
  lims = rlang::expr(vf$lims),
  n_path_int = 20,
  stepsize = 0.01,
  tol = 0.01,
  numTimeSteps = 1400,
  n = 200,
  digits = 2,
  linear = TRUE,
  ...
)
}
\arguments{
\item{vf}{A \code{vectorfield} object estimated by \code{\link[=fit_2d_vf]{fit_2d_vf()}}.}

\item{lims}{The limits of the range for the estimation as \verb{c(<xl>, <xu>, <yl>, <yu>)}.}

\item{n_path_int}{The number of equally spaced points in each axis, at which the path integrals is to be calculated.}

\item{stepsize}{The stepsize for Euler–Maruyama simulation of the system.}

\item{tol}{The tolerance to test convergence.}

\item{numTimeSteps}{Number of time steps for integrating along each path (to ensure uniform arrays). Choose high-enough number for convergence with given stepsize.}

\item{n}{The number of equally spaced points in each axis, at which the landscape is to be estimated.}

\item{digits}{Currently, the raw sample points in some regions are too dense that may crashes interpolation. To avoid this problem, only one point of all with the  same first several digits. is kept. Use this parameter to indicate how many digits are considered. Note that this is a temporary solution and might be changed in the near future.}

\item{linear}{logical – indicating whether linear or spline interpolation should be used.}

\item{...}{Not in use.}
}
\value{
A list containing the parameters of the corresponding function. Only intended to be used within \code{\link[=fit_3d_vfld]{fit_3d_vfld()}}
}
\description{
See \code{\link[=path_integral_B]{path_integral_B()}}, \code{\link[=align_pot_B]{align_pot_B()}} for details.
}
