% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/light_profile2d.R
\name{plot.light_profile2d}
\alias{plot.light_profile2d}
\title{Visualize 2D-Profiles, e.g., of Partial Dependence}
\usage{
\method{plot}{light_profile2d}(x, swap_dim = FALSE, rotate_x = TRUE, numeric_as_factor = FALSE, ...)
}
\arguments{
\item{x}{An object of class "light_profile2d".}

\item{swap_dim}{Swap the \code{\link[ggplot2:facet_grid]{ggplot2::facet_grid()}} dimensions.}

\item{rotate_x}{Should the x axis labels be rotated by 45 degrees? Default is \code{TRUE}.}

\item{numeric_as_factor}{Should numeric x and y values be converted to factors first?
Default is \code{FALSE}. Useful if \code{cut_type} was not set to "equal".}

\item{...}{Further arguments passed to \code{\link[ggplot2:geom_tile]{ggplot2::geom_tile()}}.}
}
\value{
An object of class "ggplot".
}
\description{
Minimal visualization of an object of class "light_profile2d".
The object returned is of class "ggplot" and can be further customized.
}
\details{
The main geometry is \code{\link[ggplot2:geom_tile]{ggplot2::geom_tile()}}. Additional dimensions
("by" variable(s) and/or multiflashlight) are represented by \code{facet_wrap/grid}.
For all types of profiles except "partial dependence", it is natural to see
empty parts in the plot. These are combinations of the \code{v} variables that
do not appear in the data. Even for type "partial dependence", such gaps can occur,
e.g. for \code{cut_type = "quantile"} or if \code{n_bins} are larger than the number
of distinct values of a \code{v} variable.
Such gaps can be suppressed by setting \code{numeric_as_factor = TRUE}
or by using the arguments \code{breaks}, \code{pd_evaluate_at} or \code{pd_grid} in
\code{\link[=light_profile2d]{light_profile2d()}}.
}
\seealso{
\code{\link[=light_profile2d]{light_profile2d()}}
}
