% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esttable.R
\name{estTable}
\alias{estTable}
\title{estTable}
\usage{
estTable(
  est.list,
  sae = FALSE,
  add.ci = TRUE,
  vartypes = c("variance", "ext_variance", "g_variance")
)
}
\arguments{
\item{est.list}{a \code{\link[base]{list}} object containing at least one multiphase estimation object created by
the \code{\link{twophase}} or \code{\link{threephase}} function and the respective \code{\link{onephase}} estimation object.}

\item{sae}{an object of type \code{\link[base]{logical}}. Has to be set to \code{TRUE} if results of small area estimations are passed to \code{estTable}.
Defaults to \code{FALSE}.}

\item{add.ci}{\code{logical}: Should confidence intervals be added? Defaults to \code{TRUE}.}

\item{vartypes}{Specifying the variances that should be included in the estimation table. Has to be specified as a \code{character} vector. The full set
contains \code{"variance"}, \code{"ext_variance"} and \code{"g_variance"}.}
}
\value{
\code{estTable} returns a \code{list} of the following components:

 \itemize{
    \item \code{area:} in case of small area estimations: the name of the small area
    \item \code{estimate:} the point estimates
    \item \code{vartype:} the type of variance
    \item \code{variance:} the variance values
    \item \code{std:} the standard errors (square root of variance values)
    \item \code{error:} the estimation errors defined as the ratio between \emph{standard error} and \emph{point estimate}
    \item \code{domain:} indicating if current row belongs to a \code{smallarea} or \code{global} estimation
    \item \code{estimator:} the estimator that that was applied
    \item \code{method:} the estimation method that was applied
    \item \code{n2:} terrestrial sample size in entire inventory area
    \item \code{n1:} first phase sample size in entire inventory area
    \item \code{n0:} in case of \code{threephase} estimations: zero phase sample size in entire inventory area
    \item \code{n2G:} terrestrial sample size in small area
    \item \code{n1G:} first phase sample size in small area
    \item \code{n0G:} in case of \code{threephase} estimations: zero phase sample size in small area
    \item \code{r.squared:} coefficient of determination of regression model
    \item \code{r.squared_reduced:} in case of \code{threephase} estimations: coefficient of determination of reduced regression model
    \item \code{r.squared_full:} in case of \code{threephase} estimations: coefficient of determination of full regression model
    \item \code{ci_lower:} if \code{add.ci=TRUE}: lower confidence limit
    \item \code{ci_upper:} if \code{add.ci=TRUE}: upper confidence limit
 }
}
\description{
\code{estTable} can be used to compare the results of \code{\link{onephase}} to multiphase estimations
(\code{\link{twophase}}, \code{\link{threephase}}). It restructures the estimation results into a table that can
be used to plot the estimation results and provides the basis for further analysis.
}
\note{
An estimation object of class \code{onephase} as input is mandatory
}
\examples{

## run onephase estimation:
op.a <- onephase(formula = tvol~1,
                 data = grisons,
                 phase_id = list(phase.col = "phase_id_2p", terrgrid.id = 2),
                 area = list(sa.col = "smallarea", areas = c("A", "B", "C", "D")))

## run small area twophase estimation:
sae.2p.est <- twophase(formula = tvol ~ mean + stddev + max + q75,
                       data = grisons,
                       phase_id = list(phase.col = "phase_id_2p", terrgrid.id = 2),
                       small_area = list(sa.col = "smallarea", areas = c("A", "B","C", "D"),
                                         unbiased = TRUE))

## run small area threephase estimation:
sae.3p.est <- threephase(formula.s0 =  tvol ~ mean,
                         formula.s1 = tvol ~ mean + stddev + max + q75,
                         data = grisons,
                         phase_id = list(phase.col = "phase_id_3p", s1.id = 1, terrgrid.id = 2),
                         small_area=list(sa.col = "smallarea", areas = c("A", "B", "C", "D"),
                                         unbiased = TRUE))

## create estimation table with confidence intervals:
sae.table<- estTable(est.list = list(op.a, sae.2p.est, sae.3p.est), add.ci=TRUE,
                     sae = TRUE, vartypes = c("variance", "g_variance",  "ext_variance"))

sae.table.df<- as.data.frame(sae.table)
}
