% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_fct.R
\name{set_fct}
\alias{set_fct}
\alias{set_fct.data.frame}
\alias{set_fct.default}
\title{set factor}
\usage{
set_fct(
  .data,
  ...,
  first_level = NULL,
  order_fct = FALSE,
  labels = NULL,
  max_levels = Inf
)

\method{set_fct}{data.frame}(.data, ..., first_level = NULL, order_fct = FALSE, max_levels = Inf)

\method{set_fct}{default}(.data, ..., first_level = NULL, order_fct = FALSE, max_levels = Inf)
}
\arguments{
\item{.data}{dataframe}

\item{...}{tidyselect (default selection: all character columns)}

\item{first_level}{character string to set the first level of the factor}

\item{order_fct}{logical. ordered factor?}

\item{labels}{chr vector of labels, length equal to factor levels}

\item{max_levels}{integer. uses \code{\link[forcats]{fct_lump_n}} to limit the number of categories. Only the top \code{max_levels} are preserved, and the rest being lumped into "other"}
}
\value{
tibble
}
\description{
allows option to manually set the first level of the factor, for consistency with
yardstick which automatically considers the first level
as the "positive class" when evaluating classification.
}
\examples{

## simply set the first level of a factor

iris$Species \%>\% levels

iris \%>\%
  set_fct(Species, first_level = "virginica") \%>\%
  dplyr::pull(Species) \%>\%
  levels()
}
