% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_int.R
\name{set_int}
\alias{set_int}
\alias{set_int.data.frame}
\alias{set_int.grouped_df}
\title{set integer}
\usage{
set_int(.data, ...)

\method{set_int}{data.frame}(.data, ...)

\method{set_int}{grouped_df}(.data, ...)
}
\arguments{
\item{.data}{dataframe}

\item{...}{tidyselect. Default Selecton: integerish doubles or integerish characters}
}
\value{
tibble
}
\description{
set integer
}
\examples{


int_vec <- c("1", "2", "10")

tibble::tibble(
  chr_int = int_vec,
  dbl_int = c(1.0, 5.0, 20.0),
  chr_int64 = c("1033493932", "4432500065", "30303022192"),
  string_int = c("SALES2020", "SALES2021", "SALES2022")) -> tbl

# automatically coerce integerish cols in a tibble
tbl

# integerish doubles or chars will be detected for coercion automatically
tbl \%>\%
  set_int()

# string_int requires parsing, so it must be specified directly for coercion
tbl \%>\%
  set_int(matches("str|chr"))

# s3 method works for vectors as well

int_vec

int_vec \%>\%
set_int()
}
