% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/profile_points.R
\name{profile_azimuth}
\alias{profile_azimuth}
\title{Azimuth Between Profile Points}
\usage{
profile_azimuth(x)
}
\arguments{
\item{x}{\code{sf} point object. First point marks the start point.}
}
\value{
Azimuth as \code{units} object
}
\description{
Azimuth Between Profile Points
}
\details{
If only two points are given, the azimuth is calculated using triangulation
from the \code{tectonicr} package.
If more than two points are given, the azimuth is calculated using linear
interpolation in the coordinate reference frame given by \code{profile}.
}
\examples{
p1 <- data.frame(lon = -90.8, lat = 48.6) |>
  sf::st_as_sf(coords = c("lon", "lat"), crs = "WGS84")

profile_points(p1,
  profile.azimuth = 135, profile.length = 10000,
  crs = sf::st_crs("EPSG:26915")
) |>
  profile_azimuth()
}
\seealso{
\code{\link[=profile_length]{profile_length()}}
}
