% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gerda_covariates.R
\name{gerda_covariates_codebook}
\alias{gerda_covariates_codebook}
\title{Get Codebook for County-Level Covariates}
\usage{
gerda_covariates_codebook()
}
\value{
A data frame with 22 rows documenting all variables in the county
covariates dataset.
}
\description{
Returns the data dictionary for county-level (Kreis) covariates from INKAR.
Provides variable names, labels, units, categories, original INKAR codes,
and missing data information for all county-level socioeconomic and
demographic indicators.
}
\examples{
# View the full codebook
codebook <- gerda_covariates_codebook()
print(codebook)

# Find variables by category
library(dplyr)
codebook \%>\%
  filter(category == "Demographics")

# Find variables with good coverage
codebook \%>\%
  filter(missing_pct < 5)

}
\seealso{
\code{\link{gerda_covariates}} for the actual covariate data
}
