% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_x.R
\name{scale_x_bp}
\alias{scale_x_bp}
\alias{label_bp}
\title{X-scale for genomic data}
\usage{
scale_x_bp(..., suffix = "", sep = "", accuracy = 1)

label_bp(suffix = "", sep = "", accuracy = 1)
}
\arguments{
\item{...}{Arguments passed on to \code{\link[ggplot2:scale_continuous]{ggplot2::scale_x_continuous()}}}

\item{suffix}{unit suffix e.g. "bp"}

\item{sep}{between number and unit prefix+suffix}

\item{accuracy}{A number to round to. Use (e.g.) \code{0.01} to show 2 decimal
places of precision. If \code{NULL}, the default, uses a heuristic that should
ensure breaks have the minimum number of digits needed to show the
difference between adjacent values.

Applied to rescaled data.}
}
\value{
A ggplot2 scale object with bp labels

A labeller function for genomic data
}
\description{
\code{scale_x_bp()} is the default scale for genomic x-axis. It wraps
\code{\link[ggplot2:scale_continuous]{ggplot2::scale_x_continuous()}} using \code{label_bp()} as default labeller.
}
\examples{
# scale_x_bp invoked by default
gggenomes(emale_genes) + geom_gene()

# customize labels
gggenomes(emale_genes) + geom_gene() +
  scale_x_bp(suffix = "bp", sep = " ")

# Note: xlim will overwrite scale_x_bp() with ggplot2::scale_x_continuous()
gggenomes(emale_genes) + geom_gene() +
  xlim(0, 3e4)

# set limits explicitly with scale_x_bp() to avoid overwrite
gggenomes(emale_genes) + geom_gene() +
  scale_x_bp(limits = c(0, 3e4))
}
