% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggpedigree.R
\name{ggPedigree}
\alias{ggPedigree}
\alias{ggpedigree}
\title{Plot a custom pedigree diagram}
\usage{
ggPedigree(
  ped,
  famID = "famID",
  personID = "personID",
  momID = "momID",
  dadID = "dadID",
  spouseID = "spouseID",
  matID = "matID",
  patID = "patID",
  twinID = "twinID",
  status_column = NULL,
  focal_fill_column = NULL,
  tooltip_columns = NULL,
  overlay_column = NULL,
  return_widget = FALSE,
  config = list(),
  debug = FALSE,
  hints = NULL,
  interactive = FALSE,
  phantoms = FALSE,
  ...
)

ggpedigree(
  ped,
  famID = "famID",
  personID = "personID",
  momID = "momID",
  dadID = "dadID",
  spouseID = "spouseID",
  matID = "matID",
  patID = "patID",
  twinID = "twinID",
  status_column = NULL,
  focal_fill_column = NULL,
  tooltip_columns = NULL,
  overlay_column = NULL,
  return_widget = FALSE,
  config = list(),
  debug = FALSE,
  hints = NULL,
  interactive = FALSE,
  phantoms = FALSE,
  ...
)
}
\arguments{
\item{ped}{A data frame containing the pedigree data. Needs personID, momID, and dadID columns}

\item{famID}{Character string specifying the column name for family IDs. Defaults to "famID".}

\item{personID}{Character string specifying the column name for individual IDs. Defaults to "personID".}

\item{momID}{Character string specifying the column name for mother IDs. Defaults to "momID".}

\item{dadID}{Character string specifying the column name for father IDs. Defaults to "dadID".}

\item{spouseID}{Character string specifying the column name for spouse IDs. Defaults to "spouseID".}

\item{matID}{Character string specifying the column name for maternal lines Defaults to "matID".}

\item{patID}{Character string specifying the column name for paternal lines Defaults to "patID".}

\item{twinID}{Character string specifying the column name for twin IDs. Defaults to "twinID".}

\item{status_column}{Character string specifying the column name for affected status. Defaults to NULL.}

\item{focal_fill_column}{Character string specifying the column name for focal fill color.}

\item{tooltip_columns}{Character vector of column names to show when hovering.
Defaults to c("personID", "sex").  Additional columns present in `ped`
can be supplied – they will be added to the Plotly tooltip text.
Defaults to NULL, which uses the default tooltip columns.}

\item{overlay_column}{Character string specifying the column name for overlay alpha values.}

\item{return_widget}{Logical; if TRUE (default) returns a plotly htmlwidget.
If FALSE, returns the underlying plotly object (useful for further
customization before printing).}

\item{config}{A list of configuration options for customizing the plot.
      See getDefaultPlotConfig for details. The list can include:
\describe{
   \item{code_male}{Integer or string. Value identifying males in the sex column. (typically 0 or 1) Default: 1.}
   \item{segment_spouse_color, segment_self_color}{Character. Line colors for respective connection types.}
   \item{segment_sibling_color, segment_parent_color, segment_offspring_color}{Character. Line colors for respective connection types.}
   \item{label_text_size, point_size, segment_linewidth}{Numeric. Controls text size, point size, and line thickness.}
   \item{generation_height}{Numeric. Vertical spacing multiplier between generations. Default: 1.}
   \item{shape_unknown, shape_female, shape_male, status_shape_affected}{Integers. Shape codes for plotting each group.}
   \item{sex_shape_labels}{Character vector of labels for the sex variable. (default: c("Female", "Male", "Unknown"))}
   \item{unaffected, affected}{Values indicating unaffected/affected status.}
   \item{sex_color_include}{Logical. If TRUE, uses color to differentiate sex.}
   \item{label_max_overlaps}{Maximum number of overlaps allowed in repelled labels.}
   \item{label_segment_color}{Color used for label connector lines.}
 }}

\item{debug}{Logical. If TRUE, prints debugging information. Default: FALSE.}

\item{hints}{Data frame with hints for layout adjustments. Default: NULL.}

\item{interactive}{Logical. If TRUE, generates an interactive plot using `plotly`. Default: FALSE.}

\item{phantoms}{Logical. If TRUE, adds phantom parents for individuals without parents.}

\item{...}{Additional arguments passed to `ggplot2` functions.}
}
\value{
A `ggplot` object rendering the pedigree diagram.
}
\description{
Generates a ggplot2-based diagram of a pedigree using custom coordinate layout,
calculated relationship connections, and flexible styling via `config`.
It processes the data using `ped2fam()`. This function
supports multiple families and optionally displays affected status and sex-based color/shape.
}
\examples{
library(BGmisc)
data("potter")
ggPedigree(potter, famID = "famID", personID = "personID")

data("hazard")
ggPedigree(hazard, famID = "famID", personID = "ID", config = list(code_male = 0))

}
