% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinship2_bitSize.R
\name{kinship2_bitSize}
\alias{kinship2_bitSize}
\title{Calculate the bit size of a pedigree}
\usage{
kinship2_bitSize(ped)
}
\arguments{
\item{ped}{A pedigree object}
}
\value{
A list containing:
  \item{bitSize}{The bit size of the pedigree}
  \item{nFounder}{The number of founders in the pedigree}
  \item{nNonFounder}{The number of non-founders in the pedigree}
}
\description{
This function calculates the bit size of a pedigree, which is a measure of
the information content. The bit size is calculated as 2 * (number of non-founders) -
(number of founders). This is used in pedigree.shrink functions.
}
\examples{
\dontrun{
# Example requires a pedigree object
# ped <- pedigree(id=1:5, dadid=c(0,0,1,1,1), momid=c(0,0,2,2,2),
#                 sex=c(1,2,1,2,1))
# kinship2_bitSize(ped)
}
}
\keyword{internal}
