% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pathway_errorbar.R
\name{pathway_errorbar}
\alias{pathway_errorbar}
\title{The function pathway_errorbar() is used to visualize the results of functional pathway differential abundance analysis as error bar plots.}
\arguments{
\item{abundance}{A data frame with row names representing pathways and column names representing samples. Each element represents the relative abundance of the corresponding pathway in the corresponding sample.}

\item{daa_results_df}{A data frame containing the results of the differential abundance analysis of the pathways, generated by the pathway_daa function. x_lab should be a column name of daa_results_df.}

\item{Group}{A data frame or a vector that assigns each sample to a group. The groups are used to color the samples in the figure.}

\item{ko_to_kegg}{A logical parameter indicating whether there was a convertion that convert ko abundance to kegg abundance.}

\item{p_values_threshold}{A numeric parameter specifying the threshold for statistical significance of differential abundance. Pathways with p-values below this threshold will be considered significant.}

\item{order}{A parameter controlling the ordering of the rows in the figure. The options are: "p_values" (order by p-values), "name" (order by pathway name), "group" (order by the group with the highest mean relative abundance), or "pathway_class" (order by the pathway category).}

\item{select}{A vector of pathway names to be included in the figure. This can be used to limit the number of pathways displayed. If NULL, all pathways will be displayed.}

\item{p_value_bar}{A logical parameter indicating whether to display a bar showing the p-value threshold for significance. If TRUE, the bar will be displayed.}

\item{colors}{A vector of colors to be used to represent the groups in the figure. Each color corresponds to a group. If NULL, colors will be selected based on the color_theme.}

\item{x_lab}{A character string to be used as the x-axis label in the figure. The default value is "description" for KOs'descriptions and "pathway_name" for KEGG pathway names.}

\item{log2_fold_change_color}{A character string specifying the color for log2 fold change bars. Default is "#87ceeb" (light blue). Can also be "auto" to use theme-based colors.}

\item{max_features}{A numeric parameter specifying the maximum number of features to display before issuing a warning. Default is 30. Set to a higher value to display more features, or Inf to disable the limit entirely.}

\item{color_theme}{A character string specifying the color theme to use. Options include: "default", "nature", "science", "cell", "nejm", "lancet", "colorblind_friendly", "viridis", "plasma", "minimal", "high_contrast", "pastel", "bold". Default is "default".}

\item{pathway_class_colors}{A vector of colors for pathway class annotations. If NULL, colors will be selected from the theme.}

\item{smart_colors}{A logical parameter indicating whether to use intelligent color selection based on data characteristics. Default is FALSE.}

\item{accessibility_mode}{A logical parameter indicating whether to use accessibility-friendly colors. Default is FALSE.}

\item{legend_position}{A character string specifying legend position. Options: "top", "bottom", "left", "right", "none". Default is "top".}

\item{legend_direction}{A character string specifying legend direction. Options: "horizontal", "vertical". Default is "horizontal".}

\item{legend_title}{A character string for legend title. If NULL, no title is displayed.}

\item{legend_title_size}{A numeric value specifying legend title font size. Default is 12.}

\item{legend_text_size}{A numeric value specifying legend text font size. Default is 10.}

\item{legend_key_size}{A numeric value specifying legend key size in cm. Default is 0.8.}

\item{legend_ncol}{A numeric value specifying number of columns in legend. If NULL, automatic layout is used.}

\item{legend_nrow}{A numeric value specifying number of rows in legend. If NULL, automatic layout is used.}

\item{pvalue_format}{A character string specifying p-value format. Options: "numeric", "scientific", "smart", "stars_only", "combined". Default is "smart".}

\item{pvalue_stars}{A logical parameter indicating whether to display significance stars. Default is TRUE.}

\item{pvalue_colors}{A logical parameter indicating whether to use color coding for significance levels. Default is FALSE.}

\item{pvalue_size}{A numeric value or "auto" for p-value text size. Default is "auto".}

\item{pvalue_angle}{A numeric value specifying p-value text angle in degrees. Default is 0.}

\item{pvalue_thresholds}{A numeric vector of significance thresholds. Default is c(0.001, 0.01, 0.05).}

\item{pvalue_star_symbols}{A character vector of star symbols for significance levels. Default is c("***", "**", "*").}

\item{pathway_class_text_size}{A numeric value or "auto" for pathway class text size. Default is "auto".}

\item{pathway_class_text_color}{A character string for pathway class text color. Use "auto" for theme-based color. Default is "black".}

\item{pathway_class_text_face}{A character string for pathway class text face. Options: "plain", "bold", "italic". Default is "bold".}

\item{pathway_class_text_angle}{A numeric value specifying pathway class text angle in degrees. Default is 0.}

\item{pathway_class_position}{A character string specifying pathway class position. Options: "left", "right", "none". Default is "left".}

\item{pathway_names_text_size}{A numeric value or "auto" for pathway names (y-axis labels) text size. Default is "auto".}
}
\value{
A ggplot2 plot showing the error bar plot of the differential abundance analysis results for the functional pathways.
The plot visualizes the differential abundance results of a specific differential abundance analysis method. The corresponding dataframe contains the results used to create the plot.
}
\description{
The function pathway_errorbar() is used to visualize the results of functional pathway differential abundance analysis as error bar plots.
}
\examples{
\dontrun{
# Example 1: Analyzing KEGG pathway abundance
metadata <- read_delim(
  "path/to/your/metadata.txt",
  delim = "\t",
  escape_double = FALSE,
  trim_ws = TRUE
)

# data(metadata)

kegg_abundance <- ko2kegg_abundance(
  "path/to/your/pred_metagenome_unstrat.tsv"
)

# data(kegg_abundance)

# Please change group to "your_group_column" if you are not using example dataset
group <- "Environment"

daa_results_df <- pathway_daa(
  abundance = kegg_abundance,
  metadata = metadata,
  group = group,
  daa_method = "ALDEx2",
  select = NULL,
  reference = NULL
)

# Please check the unique(daa_results_df$method) and choose one
daa_sub_method_results_df <- daa_results_df[daa_results_df$method
== "ALDEx2_Welch's t test", ]

daa_annotated_sub_method_results_df <- pathway_annotation(
  pathway = "KO",
  daa_results_df = daa_sub_method_results_df,
  ko_to_kegg = TRUE
)

# Please change Group to metadata$your_group_column if you are not using example dataset
Group <- metadata$Environment

p <- pathway_errorbar(
  abundance = kegg_abundance,
  daa_results_df = daa_annotated_sub_method_results_df,
  Group = Group,
  p_values_threshold = 0.05,
  order = "pathway_class",
  select = daa_annotated_sub_method_results_df \%>\%
  arrange(p_adjust) \%>\%
  slice(1:20) \%>\%
  select("feature") \%>\% pull(),
  ko_to_kegg = TRUE,
  p_value_bar = TRUE,
  colors = NULL,
  x_lab = "pathway_name",
  log2_fold_change_color = "#FF5733" # Custom color for log2 fold change bars
)

# Example 2: Analyzing EC, MetaCyc, KO without conversions
metadata <- read_delim(
  "path/to/your/metadata.txt",
  delim = "\t",
  escape_double = FALSE,
  trim_ws = TRUE
)
# data(metadata)

metacyc_abundance <- read.delim("path/to/your/metacyc_abundance.tsv")

# data(metacyc_abundance)

group <- "Environment"

daa_results_df <- pathway_daa(
  abundance = metacyc_abundance \%>\% column_to_rownames("pathway"),
  metadata = metadata,
  group = group,
  daa_method = "LinDA",
  select = NULL,
  reference = NULL
)


daa_annotated_results_df <- pathway_annotation(
  pathway = "MetaCyc",
  daa_results_df = daa_results_df,
  ko_to_kegg = FALSE
)

Group <- metadata$Environment

p <- pathway_errorbar(
  abundance = metacyc_abundance \%>\% column_to_rownames("pathway"),
  daa_results_df = daa_annotated_results_df,
  Group = Group,
  p_values_threshold = 0.05,
  order = "group",
  select = NULL,
  ko_to_kegg = FALSE,
  p_value_bar = TRUE,
  colors = NULL,
  x_lab = "description",
  log2_fold_change_color = "#006400" # Dark green for log2 fold change bars
)
}
}
