% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_eq.R
\name{stat_eq}
\alias{stat_eq}
\title{Add Equation to 'ggplot'}
\usage{
stat_eq(
  x,
  y,
  model = "line2P",
  show.eq = TRUE,
  xname = "x",
  yname = "y",
  yhat = FALSE,
  eq.x = NULL,
  eq.y = NULL,
  text.col = "black",
  eDigit = 3,
  eSize = 3
)
}
\arguments{
\item{x, y}{the x and y arguments provide the x and y coordinates for the 'ggplot'. Any reasonable way of defining the coordinates is acceptable.}

\item{model}{select which model to fit. Default is "line2P". The "model" should be one of c("line2P", "line3P", "log2P", "exp2P", "exp3P", "power2P", "power3P"), their formulas are as follows:\cr "line2P": y=a*x+b \cr "line3P": y=a*x^2+b*x+c \cr "log2P": y=a*ln(x)+b \cr "exp2P": y=a*exp(b*x) \cr "exp3P": y=a*exp(b*x)+c \cr "power2P": y=a*x^b \cr "power3P": y=a*x^b+c}

\item{show.eq}{whether to show the regression equation, the value is one of c("TRUE", "FALSE").}

\item{xname}{to specify the expression of "x" in equation, i.e., expression('x'), see Examples.}

\item{yname}{to specify the expression of "y" in equation, i.e., expression('y'), see Examples.}

\item{yhat}{whether to add a hat symbol (^) on the top of "y" in equation. Default is FALSE.}

\item{eq.x, eq.y}{equation position.}

\item{text.col}{the color used for the equation text.}

\item{eDigit}{the numbers of digits for equation parameters. Default is 3.}

\item{eSize}{font size of equation. Default is 3.}
}
\value{
No return value (called for side effects).
}
\description{
Add regression equation to 'ggplot',
by using different models built in the 'ggtrendline()' function. The function includes the following models: \cr
"line2P" (formula as: y=a*x+b), \cr  "line3P" (y=a*x^2+b*x+c), \cr "log2P" (y=a*ln(x)+b), \cr "exp2P" (y=a*exp(b*x)), \cr  "exp3P" (y=a*exp(b*x)+c), \cr "power2P" (y=a*x^b), \cr and "power3P" (y=a*x^b+c).
}
\details{
The values of each parameter of regression model can be found by typing \code{\link{trendline_sum}} function in this package.\cr\cr The linear models (line2P, line3P, log2P) in this package are estimated by \code{\link[stats]{lm}} function, while the nonlinear models (exp2P, exp3P, power2P, power3P) are estimated by \code{\link[stats]{nls}} function (i.e., least-squares method).
}
\seealso{
\code{\link{ggtrendline}}, \code{\link{stat_rrp}}, \code{\link{trendline_sum}}
}
