% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/branch.R, R/branch_create.R, R/branch_delete.R
\name{branch}
\alias{branch}
\alias{branch_create}
\alias{branch_delete}
\alias{branch_remove}
\title{Create and delete branches in a repository}
\usage{
branch_create(repo, branch, new_branch)

branch_delete(repo, branch)

branch_remove(repo, branch)
}
\arguments{
\item{repo}{GitHub repository address in \code{owner/repo} format.}

\item{branch}{Repository branch to use.}

\item{new_branch}{Name of branch to create.}
}
\value{
\code{branch_create()}and \code{branch_remove()} invisibly return a list containing
the results of the relevant GitHub API call.
}
\description{
\itemize{
\item \code{branch_create()} - creates a new branch from an existing GitHub repo.
\item \code{branch_delete()} - deletes a branch from an existing GitHub repo.
\item \code{branch_remove()} - previous name of \code{branch_delete}, deprecated.
}
}
\examples{
\dontrun{
repo_create("ghclass-test", "test_branch", auto_init=TRUE)

branch_create("ghclass-test/test_branch", branch = "main", new_branch = "test")
repo_branches("ghclass-test/test_branch")

branch_delete("ghclass-test/test_branch", branch="test")
repo_branches("ghclass-test/test_branch")

repo_delete("ghclass-test/test_branch", prompt = FALSE)
}

}
\seealso{
\link{repo_branches}
}
