% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/org.R, R/org_sitrep.R, R/org_update.R,
%   R/org_workflow_permissions.R
\name{org_perm}
\alias{org_perm}
\alias{org_sitrep}
\alias{org_set_repo_permission}
\alias{org_workflow_permissions}
\alias{org_set_workflow_permissions}
\title{Organization permissions}
\usage{
org_sitrep(org)

org_set_repo_permission(
  org,
  repo_permission = c("none", "read", "write", "admin")
)

org_workflow_permissions(org)

org_set_workflow_permissions(org, workflow_permission = c("read", "write"))
}
\arguments{
\item{org}{Character. Name of the GitHub organization(s).}

\item{repo_permission}{Default permission level members have for organization repositories:
\itemize{
\item read - can pull, but not push to or administer this repository.
\item write - can pull and push, but not administer this repository.
\item admin - can pull, push, and administer this repository.
\item none - no permissions granted by default.
}}

\item{workflow_permission}{The default workflow permissions granted to the GITHUB_TOKEN when
running workflows in the organization. Accepted values:\code{"read"} or \code{"write"}.}
}
\value{
\code{org_sitep()} invisibly returns the \code{org} argument.

\code{org_set_repo_permission()} invisibly return a the result of the relevant GitHub API call.

\code{org_workflow_permissions()} returns a character vector with value of either \code{"read"} or \code{"write"}.

\code{org_set_workflow_permissions()} invisibly return a the result of the relevant GitHub API call.
}
\description{
\itemize{
\item \code{org_sitrep()} - Provides a situation report on a GitHub organization.
\item \code{org_set_repo_permission()} - Change the default permission level for org repositories.
}

\code{org_workflow_permissions()} - Obtain the current default workflow permission value
for the organization.

\code{org_set_workflow_permissions()} - Change the current default workflow permission value
for the organization.
}
\examples{
\dontrun{
org_sitrep("ghclass-test")

org_set_repo_permission("ghclass-test", "read")

org_workflow_permissions("ghclass-test")

org_set_workflow_permissions("ghclass-test", "write")

org_sitrep("ghclass-test")

# Cleanup
org_set_repo_permission("ghclass-test", "none")
org_set_workflow_permissions("ghclass-test", "read")
}

}
