% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/particles.R
\name{particles}
\alias{particles}
\title{Initialize particles to perform inference in a Gaussian mixture graphical
model}
\usage{
particles(seq = NULL, col_weight = "weight", n_part = 1000)
}
\arguments{
\item{seq}{A data frame containing the observation sequences for which
particles are initialized. If \code{NULL} (the default), the initialization
is performed for a single sequence.}

\item{col_weight}{A character string corresponding to the column name of the
resulting data frame that describes the particle weight.}

\item{n_part}{A positive integer corresponding to the number of particles
initialized for each observation sequence.}
}
\value{
A data frame (tibble) containing the initial particles.
}
\description{
This function initializes particles to perform (approximate) inference in a
Gaussian mixture graphical model. Particles consist in weighted sample
sequences propagated forward in time by sampling the model and aggregated to
obtain the inferred values (Koller and Friedman, 2009).
}
\examples{
data(data_air)
part <- particles(data.frame(DATE = unique(data_air$DATE)))

}
\references{
Koller, D. and Friedman, N. (2009). \emph{Probabilistic Graphical Models:
Principles and Techniques}. The MIT Press.
}
\seealso{
\code{\link{aggregation}}, \code{\link{propagation}}
}
