% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CondKolmY.R
\name{CondKolmY}
\alias{CondKolmY}
\title{Conditional Kolmogorov test statistic for the marginal distribution
of Y}
\description{
This class inherits from \link{TestStatistic} and implements a
function to calculate the test statistic (and x-y-values that can be used
to plot the underlying process).

The process underlying the test statistic is given in Kremling & Dikta
(2024) \url{https://arxiv.org/abs/2409.20262} and defined by \deqn{\tilde{\alpha}_n(t) = \frac{1}{\sqrt{n}}
  \sum_{i=1}^n \left( I_{\{Y_i \le t\}} - F(t|\hat{\vartheta}_n, X_i)
  \right), \quad -\infty \le t \le \infty.}{(see formula given in paper).}
}
\examples{
# Create an example dataset
n <- 100
x <- cbind(runif(n), rbinom(n, 1, 0.5))
model <- NormalGLM$new()
y <- model$sample_yx(x, params=list(beta=c(2,3), sd=1))
data <- dplyr::tibble(x = x, y = y)

# Fit the correct model
model$fit(data, params_init=list(beta=c(1,1), sd=3), inplace = TRUE)

# Print value of test statistic and plot corresponding process
ts <- CondKolmY$new()
ts$calc_stat(data, model)
print(ts)
plot(ts)

# Fit a wrong model
model2 <- NormalGLM$new(linkinv = function(u) {u+10})
model2$fit(data, params_init=list(beta=c(1,1), sd=3), inplace = TRUE)

# Print value of test statistic and plot corresponding process
ts2 <- CondKolmY$new()
ts2$calc_stat(data, model2)
print(ts2)
plot(ts2)
}
\section{Super class}{
\code{\link[gofreg:TestStatistic]{gofreg::TestStatistic}} -> \code{CondKolmY}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-CondKolmY-calc_stat}{\code{CondKolmY$calc_stat()}}
\item \href{#method-CondKolmY-clone}{\code{CondKolmY$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="gofreg" data-topic="TestStatistic" data-id="geom_ts_proc"><a href='../../gofreg/html/TestStatistic.html#method-TestStatistic-geom_ts_proc'><code>gofreg::TestStatistic$geom_ts_proc()</code></a></span></li>
<li><span class="pkg-link" data-pkg="gofreg" data-topic="TestStatistic" data-id="get_plot_xy"><a href='../../gofreg/html/TestStatistic.html#method-TestStatistic-get_plot_xy'><code>gofreg::TestStatistic$get_plot_xy()</code></a></span></li>
<li><span class="pkg-link" data-pkg="gofreg" data-topic="TestStatistic" data-id="get_value"><a href='../../gofreg/html/TestStatistic.html#method-TestStatistic-get_value'><code>gofreg::TestStatistic$get_value()</code></a></span></li>
<li><span class="pkg-link" data-pkg="gofreg" data-topic="TestStatistic" data-id="plot"><a href='../../gofreg/html/TestStatistic.html#method-TestStatistic-plot'><code>gofreg::TestStatistic$plot()</code></a></span></li>
<li><span class="pkg-link" data-pkg="gofreg" data-topic="TestStatistic" data-id="print"><a href='../../gofreg/html/TestStatistic.html#method-TestStatistic-print'><code>gofreg::TestStatistic$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CondKolmY-calc_stat"></a>}}
\if{latex}{\out{\hypertarget{method-CondKolmY-calc_stat}{}}}
\subsection{Method \code{calc_stat()}}{
Calculate the value of the test statistic for given data
and a model to test for.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CondKolmY$calc_stat(data, model)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{\code{data.frame()} with columns x and y containing the data}

\item{\code{model}}{\link{ParamRegrModel} to test for, already fitted to the data}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The modified object (\code{self}), allowing for method chaining.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CondKolmY-clone"></a>}}
\if{latex}{\out{\hypertarget{method-CondKolmY-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CondKolmY$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
