% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_skeletons.R
\name{gptstudio_create_skeleton}
\alias{gptstudio_create_skeleton}
\title{Create a Request Skeleton}
\usage{
gptstudio_create_skeleton(
  service = "openai",
  prompt = "Name the top 5 packages in R.",
  history = list(list(role = "system", content = "You are an R chat assistant")),
  stream = TRUE,
  model = "gpt-3.5-turbo",
  ...
)
}
\arguments{
\item{service}{The text generation service to use. Currently supports
"openai", "huggingface", "anthropic", "google", "azure_openai", "ollama", and
"perplexity".}

\item{prompt}{The initial prompt or question to pass to the text generation
service.}

\item{history}{A list indicating the conversation history, where each element
is a list with elements "role" (who is speaking; e.g., "system", "user")
and "content" (what was said).}

\item{stream}{Logical; indicates if streaming responses should be used.
Currently, this option is not supported across all services.}

\item{model}{The specific model to use for generating responses. Defaults to
"gpt-3.5-turbo".}

\item{...}{Additional arguments passed to the service-specific skeleton
creation function.}
}
\value{
Depending on the selected service, returns a list that represents the
configured request ready to be passed to the corresponding API.
}
\description{
This function dynamically creates a request skeleton for different AI text
generation services.
}
\examples{
\dontrun{
request_skeleton <- gptstudio_create_skeleton(
  service = "openai",
  prompt = "Name the top 5 packages in R.",
  history = list(list(role = "system", content = "You are an R assistant")),
  stream = TRUE,
  model = "gpt-3.5-turbo"
)
}

}
