% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refinedBoundaries.R
\name{secondaryBoundary}
\alias{secondaryBoundary}
\title{Calculate the Refined Secondary Boundaries, Standard OBF and POC}
\usage{
secondaryBoundary(alpha, tVec, cvec, locPeak, type = 2, initIntvl = c(1, 4))
}
\arguments{
\item{alpha}{type I error.}

\item{tVec}{information vector.}

\item{cvec}{primary group sequential boundary.}

\item{locPeak}{location of maximum, a number between 1 and the number of interims.}

\item{type}{type of the test procedure for the secondary endpoint. O'Brien- Fleming (OBF) type error spending funciton is 1, Pocock (POC) type error spending funciton is 2.}

\item{initIntvl}{computing paramter, a pair of numbers containing the end-points of the interval to be searched for the root.}
}
\value{
standard O'Brien-Fleming and Pocock refined secondary boundaries.
}
\description{
Calculate the standard O'Brien-Fleming and Pocock refined secondary boundaries
}
\details{
This function calculates the standard (origiinal) O'Brien-Fleming (OBF) and Pocock (POC) refined secondary boundaries.
}
\examples{
\dontrun{
require(mvtnorm)
K <- 8
gammaVec <- sqrt((1:K)/K)
tVec <- gammaVec^2
alpha = 0.025
c <- 2.072274
cvec <- c/gammaVec
loc <- initLocPeak(alpha,tVec,cvec,type=2,initIntvl=c(1,4))
sbvec <- secondaryBoundary(alpha,tVec,cvec,loc,type=2,
       initIntvl=c(1,8))
}

}
\references{
O'Brien, P. C., and Fleming, T. R. (1979). A multiple testing procedure for clinical trials. \emph{Biometrics} \bold{35}, 549-556.

Pocock, S. J. (1977). Group sequential methods in the design and analysis of clinical trials. \emph{Biometrika} \bold{64}, 191-199.

Tamhane, A. C., Gou, J., Jennison, C., Mehta, C. R., and Curto, T. (2017+). A gatekeeping procedure to test a primary and a secondary endpoint in a group sequential design with multiple interim looks. \emph{Biometrics}, 74, 40-48.
}
\seealso{
\code{ldSecondaryBoundary}, \code{initLocBeak}
}
\author{
Jiangtao Gou
}
