% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics-generics.R
\name{correlation}
\alias{correlation}
\alias{correlation.default}
\alias{correlation.matrix}
\alias{correlation.FitLandDF}
\title{Correlation Metric for a GLCM}
\usage{
correlation(x, ...)

\method{correlation}{default}(x, ...)

\method{correlation}{matrix}(x, ...)

\method{correlation}{FitLandDF}(x, nlevels, ...)
}
\arguments{
\item{x}{gray-level co-occurrence matrix}

\item{...}{additional parameters}

\item{nlevels}{desired number of discrete gray levels}
}
\value{
double
}
\description{
Calculate the correlation feature or metric for a gray-level co-occurrence
matrix. For definition and application, see Lofstedt et al. (2019)
\doi{10.1371/journal.pone.0212110}.
}
\examples{
## calculate correlation of arbitrary GLCM
# define arbitrary GLCM
x <- matrix(1:16, nrow = 4)

# normalize
n_x <- normalize_glcm(x)

# calculate correlation
correlation(n_x)

## calculate autocorrelation of arbitrary fitness landscape
# create fitness landscape using FitLandDF object
vals <- runif(64)
vals <- array(vals, dim = rep(4, 3))
my_landscape <- fitscape::FitLandDF(vals)

# calculate correlation of fitness landscape, assuming 2 discrete gray levels
correlation(my_landscape, nlevels = 2)

## confirm value of correlation for fitness landscape
# extract normalized GLCM from fitness landscape
my_glcm <- get_comatrix(my_landscape, discrete = equal_discrete(2))

# calculate correlation of extracted GLCM
correlation(my_glcm)  # should match value of above correlation function call
}
