% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Golden.R
\name{Golden}
\alias{Golden}
\title{Golden Section Search}
\usage{
Golden(
  data,
  formula,
  xvarinf = NULL,
  weight = NULL,
  lat,
  long,
  globalmin = TRUE,
  method,
  model = "zinb",
  bandwidth = "cv",
  offset = NULL,
  force = FALSE,
  maxg = 100,
  distancekm = FALSE
)
}
\arguments{
\item{data}{name of the dataset.}

\item{formula}{regression model formula as in \code{lm}.}

\item{xvarinf}{name of the covariates for the zero inflated part of the model, default value is \code{NULL}.}

\item{weight}{name of the variable containing the sample weights, default value is \code{NULL}.}

\item{lat}{name of the variable containing the latitudes in the dataset.}

\item{long}{name of the variable containing the longitudes in the dataset.}

\item{globalmin}{logical value indicating whether to find a global minimum in the optimization process, default value is \code{TRUE}.}

\item{method}{indicates the method to be used for the bandwidth calculation (\code{adaptive_bsq} or \code{fixed_g}).}

\item{model}{indicates the model to be used for the regression (\code{zinb}, \code{zip}, \code{negbin}, \code{poisson}), default value is\code{"zinb"}.}

\item{bandwidth}{indicates the criterion to be used for the bandwidth calculation (\code{cv}, \code{aic}), default value is \code{"cv"}.}

\item{offset}{name of the variable containing the offset values, if null then is set to a vector of zeros, default value is \code{NULL}.}

\item{force}{logical value indicating whether to force the indicated model even if it is not the best fit for the data, default value is \code{FALSE}.}

\item{maxg}{integer indicating the maximum number of iterations for the zero inflated part of the model, default value is \code{100}.}

\item{distancekm}{logical value indicating whether to calculate the distances in km, default value is \code{FALSE}.}
}
\value{
A list that contains:

\itemize{
\item \code{h_values} - Initial values tested for the bandwidth.
\item \code{iterations} - All bandwidth values tested and respective cv/aic results for each Golden Section Search executed.
\item \code{gss_results} - Optimum bandwidth found and respective cv/aic.
\item \code{min_bandwidth} - Optimum bandwidth.
}
}
\description{
Runs a Golden Section Search (GSS) algorithm for determining the optimum bandwidth for the geographically weighted zero inflated negative binomial regression and other spatial regression models.
}
\examples{
## Data


data(southkorea_covid19)


## GSS algorithm

gss <- Golden(data = southkorea_covid19[1:122, ],
formula = n_covid1~diff_sd,
xvarinf = NULL, weight = NULL, lat = "y", long = "x",
offset = NULL, model = "poisson", method = "fixed_g",
bandwidth = "cv", globalmin = FALSE, distancekm = FALSE,
force=FALSE)

## Bandwidth
gss$min_bandwidth

## Iterations
gss$iterations

}
