% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SNPs_scatter_plot.R
\name{SNPs_scatter_plot}
\alias{SNPs_scatter_plot}
\title{Scatter plot for all the SNPs used in the analysis}
\usage{
SNPs_scatter_plot(A, betas.Gy, num_X)
}
\arguments{
\item{A}{The effects of SNPs on the exposures (Gx).}

\item{betas.Gy}{The betas in the paper: the marginal effects of SNPs on the phenotype (Gy)}

\item{num_X}{The number of intermediates in the research question.}
}
\value{
A set of scatter plots with x-axis being the conditional \eqn{\alpha}{alpha} estimates for each
intermediate and y-axis being the \eqn{\beta}{beta} estimates.
}
\description{
To generate the scatter plot of all the SNPs that the user use in the analysis
}
\examples{
data(conditional_A)
data(betas.Gy)
t = SNPs_scatter_plot(A = conditional_A, betas.Gy = betas.Gy, num_X = 2)
t
}
\author{
Lai Jiang
}
