% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{adjust_ages}
\alias{adjust_ages}
\alias{adjust_plus_min_ages_df}
\alias{adjust_plus_min_ages}
\title{Adjusts data to account for plus group or minimum age}
\usage{
adjust_plus_min_ages_df(data, minage = NULL, pls_grp = NULL)

adjust_plus_min_ages(age_vec, minage = NULL, pls_grp = NULL)
}
\arguments{
\item{data}{Data with age as a column, or a numeric vector of ages}

\item{minage}{Numeric. The minimum age; everything else is excluded}

\item{pls_grp}{Numeric. The plus group; all ages older will be lumped into
this group}

\item{age_vec}{A vector of ages}
}
\value{
A data.frame similar to \code{data}, but with ages less than
\code{minage} excluded and ages >= \code{plus_group} aggregated into that age
}
\description{
These functions performs two tasks. It lumps all ages greater than the
plus group into that age, and it filters data only to those greater than
or equal to the minimum age. \code{adjust_plus_min_ages} works on a vector
whereas \code{adjust_plus_min_ages_df} words on a data.frame
}
