% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalization.R
\name{normalization}
\alias{normalization}
\title{Apply Normalization Techniques to the Dataset}
\usage{
normalization(data, type = "n0", norm = "column", na.remove = FALSE)
}
\arguments{
\item{data}{Dataset in \code{data.frame} format.}

\item{type}{Type of normalization. Default is "n1".
\itemize{
\item n0: without normalization
\item n1: standardization ((x-mean)/sd)
\item n2: positional standardization ((x-median)/mad)
\item n3: unitization ((x-mean)/range)
\item n3a: positional unitization ((x-median)/range)
\item n4: unitization with zero minimum ((x-min)/range)
\item n5: normalization in range <-1,1> ((x-mean)/max(abs(x-mean)))
\item n5a: positional normalization in range <-1,1> ((x-median)/max(abs(x-median)))
\item n6: quotient transformation (x/sd)
\item n6a: positional quotient transformation (x/mad)
\item n7: quotient transformation (x/range)
\item n8: quotient transformation (x/max)
\item n9: quotient transformation (x/mean)
\item n9a: positional quotient transformation (x/median)
\item n10: quotient transformation (x/sum)
\item n11: quotient transformation (x/sqrt(SSQ))
\item n12: normalization ((x-mean)/sqrt(sum((x-mean)^2)))
\item n12a: positional normalization ((x-median)/sqrt(sum((x-median)^2)))
\item n13: normalization with zero being the central point ((x-midrange)/(range/2))
}}

\item{norm}{Defines whether the normalization will be done by "column" or
by "row". Default is "column".}

\item{na.remove}{A \code{logical} value indicating whether NA values should be
excluded before performing normalization calculations. Default is FALSE.}
}
\value{
Normalized dataset in \code{data.frame} foramt.
}
\description{
Perform data normalization.
}
\examples{
# Load the required package
library(hclusteasy)


# Read the dataset 'iris' from the package
data("iris_uci")

# Remove the column 'Species' from the iris dataset
iris <- iris_uci[, -5]


# Apply normalization to the iris dataset
irisN <- normalization(iris, type = "n1")

}
