% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/hdf5-methods.R
\name{h5Delete}
\alias{h5Delete}
\alias{h5Delete.H5Group}
\alias{h5Delete.H5File}
\alias{h5Delete.character}
\title{Delete an HDF5 link}
\usage{
h5Delete(x, name, ...)

\method{h5Delete}{H5Group}(x, name, verbose = TRUE, ...)

\method{h5Delete}{H5File}(x, name, verbose = TRUE, ...)

\method{h5Delete}{character}(x, name, verbose = TRUE, ...)
}
\arguments{
\item{x}{An existing HDF5 file}

\item{name}{Name of HDF5 link to be deleted. If \code{name} doesn't exist, 
nothing will be done.}

\item{...}{Arguments passed to \code{H5Group$link_delete()}}

\item{verbose}{Print progress.}
}
\value{
This is an operation function and no return. Any failure should raise an 
error.
}
\description{
Delete an HDF5 link
}
\examples{
file <- system.file("extdata", "pbmc_small.h5ad", package = "hdf5r.Extra")
to.file <- tempfile(fileext = ".h5")
file.copy(file, to.file)

h5Delete(to.file, "obs")
h5Delete(to.file, "xxxx") # Delete something not existing.

}
