% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/C2pop.R
\name{adaptP}
\alias{adaptP}
\title{Adapt a Transition Matrix to a Specific Stationary Distribution}
\usage{
adaptP(P, target, niter = 1e+06)
}
\arguments{
\item{P}{a transition matrix, i.e., a square matrix where all rows sum to 1.}

\item{target}{the stationary probability vector to approximate.}

\item{niter}{the number of iterations of the MCMC algorithm}
}
\value{
the adjusted transition matrix.
}
\description{
\strong{Experimental} Metropolis-Hastings algorithm, which tries
to adjust a transition matrix such that its stationary distribution
becomes approximately equal to a prespecified probability vector.
}
\examples{
## a row-normalized contact matrix
C <- matrix(c(0.8, 0.1, 0.1,
              0.2, 0.6, 0.2,
              0.1, 0.2, 0.7), byrow=TRUE, ncol=3, nrow=3)
stationary(C)
## population fractions define the target distribution
popfracs <- c(0.4, 0.3, 0.3)
## adapt 'C' to the given population fractions
Cpop <- adaptP(C, popfracs, niter = 50000)
stationary(Cpop)
## this method increases the diagonal values of 'C'
round(C, 3)
round(Cpop, 3)
round(Cpop/C, 3)
}
\seealso{
\code{\link{C2pop}} for an alternative method.
}
\author{
Leonhard Held
}
