# code information gathered from:
# https://developer.mozilla.org/en-US/docs/Web/HTTP/Status
# https://en.wikipedia.org/wiki/List_of_HTTP_status_codes
# http://getstatuscode.com

# format for each code:
# - title: very short name 
# - message: message given explaning what the code means in most http status code scenarios
# - explanation: longer explanation of the status code; this is often empty (`NULL`) if none available

status_codes <- list(
  # Informational
  `100` = list('Continue', 'Request received, please continue', "The client SHOULD continue with its request. This interim response is used to inform the client that the initial part of the request has been received and has not yet been rejected by the server. The client SHOULD continue by sending the remainder of the request or, if the request has already been completed, ignore this response. The server MUST send a final response after the request has been completed. See section 8.2.3 for detailed discussion of the use and handling of this status code."),
  `101` = list('Switching Protocols', 'Switching to new protocol; obey Upgrade header', "The server understands and is willing to comply with the client's request, via the Upgrade message header field (section 14.42), for a change in the application protocol being used on this connection. The server will switch protocols to those defined by the response's Upgrade header field immediately after the empty line which terminates the 101 response.\nThe protocol SHOULD be switched only when it is advantageous to do so. For example, switching to a newer version of HTTP is advantageous over older versions, and switching to a real-time, synchronous protocol might be advantageous when delivering resources that use such features."),
  `102` = list('Processing', 'This code indicates that the server has received and is processing the request, but no response is available yet (WebDAV; RFC 2518)', NULL),
  # Success
  `200` = list('OK', 'Request fulfilled, document follows', "The request has succeeded. The information returned with the response is dependent on the method used in the request, for example:\nGET    an entity corresponding to the requested resource is sent in the response;\nHEAD   the entity-header fields corresponding to the requested resource are sent in the response without any message-body;\nPOST   an entity describing or containing the result of the action;\n TRACE  an entity containing the request message as received by the end server."),
  `201` = list('Created', 'Document created, URL follows', "The request has been fulfilled and resulted in a new resource being created. The newly created resource can be referenced by the URI(s) returned in the entity of the response, with the most specific URI for the resource given by a Location header field. The response SHOULD include an entity containing a list of resource characteristics and location(s) from which the user or user agent can choose the one most appropriate. The entity format is specified by the media type given in the Content-Type header field. The origin server MUST create the resource before returning the 201 status code. If the action cannot be carried out immediately, the server SHOULD respond with 202 (Accepted) response instead.\nA 201 response MAY contain an ETag response header field indicating the current value of the entity tag for the requested variant just created, see section 14.19."),
  `202` = list('Accepted', 'Request accepted, processing continues off-line', "The request has been accepted for processing, but the processing has not been completed.  The request might or might not eventually be acted upon, as it might be disallowed when processing actually takes place. There is no facility for re-sending a status code from an asynchronous operation such as this.\nThe 202 response is intentionally non-committal. Its purpose is to allow a server to accept a request for some other process (perhaps a batch-oriented process that is only run once per day) without requiring that the user agent's connection to the server persist until the process is completed. The entity returned with this response SHOULD include an indication of the request's current status and either a pointer to a status monitor or some estimate of when the user can expect the request to be fulfilled."),
  `203` = list('Non-Authoritative Information', 'Request fulfilled from cache', "The returned metainformation in the entity-header is not the definitive set as available from the origin server, but is gathered from a local or a third-party copy. The set presented MAY be a subset or superset of the original version. For example, including local annotation information about the resource might result in a superset of the metainformation known by the origin server. Use of this response code is not required and is only appropriate when the response would otherwise be 200 (OK)."),
  `204` = list('No Content', 'Request fulfilled, nothing follows', "The server has fulfilled the request but does not need to return an entity-body, and might want to return updated metainformation. The response MAY include new or updated metainformation in the form of entity-headers, which if present SHOULD be associated with the requested variant.\nIf the client is a user agent, it SHOULD NOT change its document view from that which caused the request to be sent. This response is primarily intended to allow input for actions to take place without causing a change to the user agent's active document view, although any new or updated metainformation SHOULD be applied to the document currently in the user agent's active view.\nThe 204 response MUST NOT include a message-body, and thus is always terminated by the first empty line after the header fields."),
  `205` = list('Reset Content', 'Clear input form for further input.', "The server has fulfilled the request and the user agent SHOULD reset the document view which caused the request to be sent. This response is primarily intended to allow input for actions to take place via user input, followed by a clearing of the form in which the input is given so that the user can easily initiate another input action. The response MUST NOT include an entity."),
  `206` = list('Partial Content', 'Partial content follows.', "The server has fulfilled the partial GET request for the resource. The request MUST have included a Range header field (section 14.35) indicating the desired range, and MAY have included an If-Range header field (section 14.27) to make the request conditional.\nThe response MUST include the following header fields:\n- Either a Content-Range header field (section 14.16) indicating the range included with this response, or a multipart/byteranges Content-Type including Content-Range fields for each part. If a Content-Length header field is present in the response, its value MUST match the actual number of OCTETs transmitted in the message-body.\n  - Date\n  - ETag and/or Content-Location, if the header would have been sent in a 200 response to the same request\n  - Expires, Cache-Control, and/or Vary, if the field-value might differ from that sent in any previous response for the same variant\nIf the 206 response is the result of an If-Range request that used a strong cache validator (see section 13.3.3), the response SHOULD NOT include other entity-headers. If the response is the result of an If-Range request that used a weak validator, the response MUST NOT include other entity-headers; this prevents inconsistencies between cached entity-bodies and updated headers. Otherwise, the response MUST include all of the entity-headers that would have been returned with a 200 (OK) response to the same request.\nA cache MUST NOT combine a 206 response with other previously cached content if the ETag or Last-Modified headers do not match exactly, see 13.5.4.\nA cache that does not support the Range and Content-Range headers MUST NOT cache 206 (Partial) responses."),
  `207` = list('Multi-Status', 'Conveys information about multiple resources, for situations where multiple status codes might be appropriate (WebDAV; RFC 4918)', NULL),
  `208` = list('Already Reported', 'Used inside a <dav:propstat> response element to avoid repeatedly enumerating the internal members of multiple bindings to the same collection. (WebDAV; RFC 5842)', NULL),
  `226` = list('IM Used', 'The server has fulfilled a GET request for the resource, and the response is a representation of the result of one or more instance-manipulations applied to the current instance (RFC 3229)', NULL),
  # Redirection
  `300` = list('Multiple Choices', 'Object has several resources -- see URI list', "The requested resource corresponds to any one of a set of representations, each with its own specific location, and agent- driven negotiation information (section 12) is being provided so that the user (or user agent) can select a preferred representation and redirect its request to that location.\nUnless it was a HEAD request, the response SHOULD include an entity containing a list of resource characteristics and location(s) from which the user or user agent can choose the one most appropriate. The entity format is specified by the media type given in the Content-Type header field. Depending upon the format and the capabilities of the user agent, selection of the most appropriate choice MAY be performed automatically. However, this specification does not define any standard for such automatic selection.\nIf the server has a preferred choice of representation, it SHOULD include the specific URI for that representation in the Location field; user agents MAY use the Location field value for automatic redirection. This response is cacheable unless indicated otherwise."),
  `301` = list('Moved Permanently', 'Object moved permanently -- see URI list', "The requested resource has been assigned a new permanent URI and any future references to this resource SHOULD use one of the returned URIs.  Clients with link editing capabilities ought to automatically re-link references to the Request-URI to one or more of the new references returned by the server, where possible. This response is cacheable unless indicated otherwise.\nThe new permanent URI SHOULD be given by the Location field in the response. Unless the request method was HEAD, the entity of the response SHOULD contain a short hypertext note with a hyperlink to the new URI(s).\nIf the 301 status code is received in response to a request other than GET or HEAD, the user agent MUST NOT automatically redirect the request unless it can be confirmed by the user, since this might change the conditions under which the request was issued.\nNote: When automatically redirecting a POST request after receiving a 301 status code, some existing HTTP/1.0 user agents will erroneously change it into a GET request."),
  `302` = list('Found', 'Object moved temporarily -- see URI list', "The requested resource resides temporarily under a different URI. Since the redirection might be altered on occasion, the client SHOULD continue to use the Request-URI for future requests.  This response is only cacheable if indicated by a Cache-Control or Expires header field.\nThe temporary URI SHOULD be given by the Location field in the response. Unless the request method was HEAD, the entity of the response SHOULD contain a short hypertext note with a hyperlink to the new URI(s).\nIf the 302 status code is received in response to a request other than GET or HEAD, the user agent MUST NOT automatically redirect the request unless it can be confirmed by the user, since this might change the conditions under which the request was issued.\nNote: RFC 1945 and RFC 2068 specify that the client is not allowed to change the method on the redirected request.  However, most existing user agent implementations treat 302 as if it were a 303 response, performing a GET on the Location field-value regardless of the original request method. The status codes 303 and 307 have been added for servers that wish to make unambiguously clear which kind of reaction is expected of the client."),
  `303` = list('See Other', 'Object moved -- see Method and URL list', "The response to the request can be found under a different URI and SHOULD be retrieved using a GET method on that resource. This method exists primarily to allow the output of a POST-activated script to redirect the user agent to a selected resource. The new URI is not a substitute reference for the originally requested resource. The 303 response MUST NOT be cached, but the response to the second (redirected) request might be cacheable.\nThe different URI SHOULD be given by the Location field in the response. Unless the request method was HEAD, the entity of the response SHOULD contain a short hypertext note with a hyperlink to the new URI(s).\n Note: Many pre-HTTP/1.1 user agents do not understand the 303 status. When interoperability with such clients is a concern, the 302 status code may be used instead, since most user agents react to a 302 response as described here for 303."),
  `304` = list('Not Modified', 'Document has not changed since given time', "If the client has performed a conditional GET request and access is allowed, but the document has not been modified, the server SHOULD respond with this status code. The 304 response MUST NOT contain a message-body, and thus is always terminated by the first empty line after the header fields.\nThe response MUST include the following header fields:\n- Date, unless its omission is required by section 14.18.1\nIf a clockless origin server obeys these rules, and proxies and clients add their own Date to any response received without one (as already specified by [RFC 2068], section 14.19), caches will operate correctly.\n- ETag and/or Content-Location, if the header would have been sent in a 200 response to the same request\n- Expires, Cache-Control, and/or Vary, if the field-value might differ from that sent in any previous response for the same variant\nIf the conditional GET used a strong cache validator (see section 13.3.3), the response SHOULD NOT include other entity-headers. Otherwise (i.e., the conditional GET used a weak validator), the response MUST NOT include other entity-headers; this prevents inconsistencies between cached entity-bodies and updated headers.\nIf a 304 response indicates an entity not currently cached, then the cache MUST disregard the response and repeat the request without the conditional.\nIf a cache uses a received 304 response to update a cache entry, the cache MUST update the entry to reflect any new field values given in the response."),
  `305` = list('Use Proxy', 'You must use proxy specified in Location to access this resource.', "The requested resource MUST be accessed through the proxy given by the Location field. The Location field gives the URI of the proxy. The recipient is expected to repeat this single request via the proxy. 305 responses MUST only be generated by origin servers.\nNote: RFC 2068 was not clear that 305 was intended to redirect a single request, and to be generated by origin servers only.  Not observing these limitations has significant security consequences."),
  `306` = list('Switch Proxy', 'Subsequent requests should use the specified proxy', "The 306 status code was used in a previous version of the secification, is no longer used, and the code is reserved."),
  `307` = list('Temporary Redirect', 'Object moved temporarily -- see URI list',"The requested resource resides temporarily under a different URI. Since the redirection MAY be altered on occasion, the client SHOULD continue to use the Request-URI for future requests.  This response is only cacheable if indicated by a Cache-Control or Expires header field\nThe temporary URI SHOULD be given by the Location field in the response. Unless the request method was HEAD, the entity of the response SHOULD contain a short hypertext note with a hyperlink to the new URI(s) , since many pre-HTTP/1.1 user agents do not understand the 307 status. Therefore, the note SHOULD contain the information necessary for a user to repeat the original request on the new URI.\nIf the 307 status code is received in response to a request other than GET or HEAD, the user agent MUST NOT automatically redirect the request unless it can be confirmed by the user, since this might change the conditions under which the request was issued."),
  `308` = list('Permanent Redirect', 'Object moved permanently', "This means that the resource is now permanently located at another URI, specified by the Location: HTTP Response header. This has the same semantics as the 301 Moved Permanently HTTP response code, with the exception that the user agent must not change the HTTP method used: If a POST was used in the first request, a POST must be used in the second request."),
  # Client errors
  `400` = list('Bad Request', 'Bad request syntax or unsupported method', "The request could not be understood by the server due to malformed syntax. The client SHOULD NOT repeat the request without modifications."),
  `401` = list('Unauthorized', 'No permission -- see authorization schemes', "The request requires user authentication. The response MUST include a WWW-Authenticate header field (section 14.47) containing a challenge applicable to the requested resource. The client MAY repeat the request with a suitable Authorization header field (section 14.8). If the request already included Authorization credentials, then the 401 response indicates that authorization has been refused for those credentials. If the 401 response contains the same challenge as the prior response, and the user agent has already attempted authentication at least once, then the user SHOULD be presented the entity that was given in the response, since that entity might include relevant diagnostic information. HTTP access authentication is explained in HTTP Authentication: Basic and Digest Access Authentication [43]."),
  `402` = list('Payment Required', 'No payment -- see charging schemes', "This code is reserved for future use."),
  `403` = list('Forbidden', 'Request forbidden -- authorization will not help', "The server understood the request, but is refusing to fulfill it. Authorization will not help and the request SHOULD NOT be repeated. If the request method was not HEAD and the server wishes to make public why the request has not been fulfilled, it SHOULD describe the reason for the refusal in the entity.  If the server does not wish to make this information available to the client, the status code 404 (Not Found) can be used instead."),
  `404` = list('Not Found', 'Nothing matches the given URI', "The server has not found anything matching the Request-URI. No indication is given of whether the condition is temporary or permanent. The 410 (Gone) status code SHOULD be used if the server knows, through some internally configurable mechanism, that an old resource is permanently unavailable and has no forwarding address. This status code is commonly used when the server does not wish to reveal exactly why the request has been refused, or when no other response is applicable."),
  `405` = list('Method Not Allowed', 'Specified method is invalid for this resource.', "The method specified in the Request-Line is not allowed for the resource identified by the Request-URI. The response MUST include an Allow header containing a list of valid methods for the requested resource."),
  `406` = list('Not Acceptable', 'URI not available in preferred format.', "The resource identified by the request is only capable of generating response entities which have content characteristics not acceptable according to the accept headers sent in the request.\nUnless it was a HEAD request, the response SHOULD include an entity containing a list of available entity characteristics and location(s) from which the user or user agent can choose the one most appropriate. The entity format is specified by the media type given in the Content-Type header field. Depending upon the format and the capabilities of the user agent, selection of the most appropriate choice MAY be performed automatically. However, this specification does not define any standard for such automatic selection.\nNote: HTTP/1.1 servers are allowed to return responses which are not acceptable according to the accept headers sent in the request. In some cases, this may even be preferable to sending a 406 response. User agents are encouraged to inspect the headers of an incoming response to determine if it is acceptable.\nIf the response could be unacceptable, a user agent SHOULD temporarily stop receipt of more data and query the user for a decision on further actions."),
  `407` = list('Proxy Authentication Required', 'You must authenticate with this proxy before proceeding.', "This code is similar to 401 (Unauthorized), but indicates that the client must first authenticate itself with the proxy. The proxy MUST return a Proxy-Authenticate header field (section 14.33) containing a challenge applicable to the proxy for the requested resource. The client MAY repeat the request with a suitable Proxy-Authorization header field (section 14.34). HTTP access authentication is explained in HTTP Authentication: Basic and Digest Access Authentication [43]."),
  `408` = list('Request Timeout', 'Request timed out; try again later.', "The client did not produce a request within the time that the server was prepared to wait. The client MAY repeat the request without modifications at any later time."),
  `409` = list('Conflict', 'Request conflict.', "The request could not be completed due to a conflict with the current state of the resource. This code is only allowed in situations where it is expected that the user might be able to resolve the conflict and resubmit the request. The response body SHOULD include enough information for the user to recognize the source of the conflict. Ideally, the response entity would include enough information for the user or user agent to fix the problem; however, that might not be possible and is not required.\nConflicts are most likely to occur in response to a PUT request. For example, if versioning were being used and the entity being PUT included changes to a resource which conflict with those made by an earlier (third-party) request, the server might use the 409 response to indicate that it can't complete the request. In this case, the response entity would likely contain a list of the differences between the two versions in a format defined by the response Content-Type."),
  `410` = list('Gone', 'URI no longer exists and has been permanently removed.', "The requested resource is no longer available at the server and no forwarding address is known. This condition is expected to be considered permanent. Clients with link editing capabilities SHOULD delete references to the Request-URI after user approval. If the server does not know, or has no facility to determine, whether or not the condition is permanent, the status code 404 (Not Found) SHOULD be used instead. This response is cacheable unless indicated otherwise.\nThe 410 response is primarily intended to assist the task of web maintenance by notifying the recipient that the resource is intentionally unavailable and that the server owners desire that remote links to that resource be removed. Such an event is common for limited-time, promotional services and for resources belonging to individuals no longer working at the server's site. It is not necessary to mark all permanently unavailable resources as 'gone' or to keep the mark for any length of time -- that is left to the discretion of the server owner."),
  `411` = list('Length Required', 'Client must specify Content-Length.', "The server refuses to accept the request without a defined Content-Length. The client MAY repeat the request if it adds a valid Content-Length header field containing the length of the message-body in the request message."),
  `412` = list('Precondition Failed', 'Precondition in headers is false.', "The precondition given in one or more of the request-header fields evaluated to false when it was tested on the server. This response code allows the client to place preconditions on the current resource metainformation (header field data) and thus prevent the requested method from being applied to a resource other than the one intended."),
  `413` = list('Request Entity Too Large', 'Entity is too large.', "The server is refusing to process a request because the request entity is larger than the server is willing or able to process. The server MAY close the connection to prevent the client from continuing the request.\nIf the condition is temporary, the server SHOULD include a Retry-After header field to indicate that it is temporary and after what time the client MAY try again."),
  `414` = list('Request-URI Too Long', 'URI is too long.', "The server is refusing to service the request because the Request-URI is longer than the server is willing to interpret. This rare condition is only likely to occur when a client has improperly converted a POST request to a GET request with long query information, when the client has descended into a URI 'black hole' of redirection (e.g., a redirected URI prefix that points to a suffix of itself), or when the server is under attack by a client attempting to exploit security holes present in some servers using fixed-length buffers for reading or manipulating the Request-URI."),
  `415` = list('Unsupported Media Type', 'Entity body in unsupported format.', "The server is refusing to service the request because the entity of the request is in a format not supported by the requested resource for the requested method."),
  `416` = list('Requested Range Not Satisfiable', 'Cannot satisfy request range.', "A server SHOULD return a response with this status code if a request included a Range request-header field (section 14.35), and none of the range-specifier values in this field overlap the current extent of the selected resource, and the request did not include an If-Range request-header field. (For byte-ranges, this means that the first- byte-pos of all of the byte-range-spec values were greater than the current length of the selected resource.)\nWhen this status code is returned for a byte-range request, the response SHOULD include a Content-Range entity-header field specifying the current length of the selected resource (see section 14.16). This response MUST NOT use the multipart/byteranges content-type."),
  `417` = list('Expectation Failed', 'Expect condition could not be satisfied.', "The expectation given in an Expect request-header field (see section 14.20) could not be met by this server, or, if the server is a proxy, the server has unambiguous evidence that the request could not be met by the next-hop server."),
  `418` = list("I'm a teapot", 'The server refuses the attempt to brew coffee with a teapot.', NULL),
  `419` = list('Authentication Timeout', 'previously valid authentication has expired', 'used as an alternative to 401 Unauthorized in order to differentiate from otherwise authenticated clients being denied access to specific server resources'),
  `420` = list('Enhance Your Calm', 'Returned by version 1 of the Twitter Search and Trends API when the client is being rate limited (Twitter)', NULL),
  `421` = list('Misdirected Request', 'The request was directed at a server that is not able to produce a response', "This can be sent by a server that is not configured to produce responses for the combination of scheme and authority that are included in the request URI."),
  `422` = list('Unprocessable Entity', 'The request was well-formed but was unable to be followed due to semantic errors (WebDAV; RFC 4918)', NULL),
  `423` = list('Locked', 'The resource that is being accessed is locked (WebDAV; RFC 4918)', NULL),
  `424` = list('Failed Dependency', 'The request failed due to failure of a previous request (WebDAV; RFC 4918)', NULL),
  `425` = list('Too Early', 'Indicates that the server is unwilling to risk processing a request that might be replayed.', NULL),
  `426` = list('Upgrade Required', 'The client should switch to a different protocol', "The server refuses to perform the request using the current protocol but might be willing to do so after the client upgrades to a different protocol. The server sends an Upgrade header in a 426 response to indicate the required protocol(s)."),
  `428` = list('Precondition Required', 'The origin server requires the request to be conditional (RFC 6585)', "The origin server requires the request to be conditional. This response is intended to prevent the 'lost update' problem, where a client GETs a resource's state, modifies it, and PUTs it back to the server, when meanwhile a third party has modified the state on the server, leading to a conflict."),
  `429` = list('Too Many Requests', 'The user has sent too many requests in a given amount of time ("rate limiting") (RFC 6585)', NULL),
  `431` = list('Request Header Fields Too Large', 'The server is unwilling to process the request because its header fields are too large. The request may be resubmitted after reducing the size of the request header fields (RFC 6585)', NULL),
  `451` = list('Unavailable For Legal Reasons', 'The user-agent requested a resource that cannot legally be provided, such as a web page censored by a government (RFC 7725)', NULL),
  # Microsoft
  `440` = list('Login Timeout (Microsoft)', 'The clients session has expired and must log in again', NULL),
  `449` = list('Retry With (Microsoft)', 'The server cannot honour the request because the user has not provided the required information', NULL),
  `450` = list('Blocked by Windows Parental Controls (Microsoft)', 'The Microsoft extension code indicated when Windows Parental Controls are turned on and are blocking access to the requested webpage', NULL),
  # ESRI
  `498` = list('Token expired/invalid (Esri)', 'Returned by ArcGIS Server. An expired or otherwise invalid token', NULL),
  # `499` = list('Token expired/invalid', 'Esri', NULL), # Nginx 499 seems clearly more important
  # Server errors
  `500` = list('Internal Server Error', 'Server got itself in trouble', "The server encountered an unexpected condition which prevented it from fulfilling the request."),
  `501` = list('Not Implemented', 'Server does not support this operation', "The server does not support the functionality required to fulfill the request. This is the appropriate response when the server does not recognize the request method and is not capable of supporting it for any resource."),
  `502` = list('Bad Gateway', 'Invalid responses from another server/proxy.', "The server, while acting as a gateway or proxy, received an invalid response from the upstream server it accessed in attempting to fulfill the request."),
  `503` = list('Service Unavailable', 'The server cannot process the request due to a high load', "The server is currently unable to handle the request due to a temporary overloading or maintenance of the server. The implication is that this is a temporary condition which will be alleviated after some delay. If known, the length of the delay MAY be indicated in a Retry-After header. If no Retry-After is given, the client SHOULD handle the response as it would for a 500 response.\nNote: The existence of the 503 status code does not imply that a server must use it when becoming overloaded. Some servers may wish to simply refuse the connection."),
  `504` = list('Gateway Timeout', 'The gateway server did not receive a timely response', "The server, while acting as a gateway or proxy, did not receive a timely response from the upstream server specified by the URI (e.g. HTTP, FTP, LDAP) or some other auxiliary server (e.g. DNS) it needed to access in attempting to complete the request.\nNote: Note to implementors: some deployed proxies are known to return 400 or 500 when DNS lookups time out."),
  `505` = list('HTTP Version Not Supported', 'Cannot fulfill request.', "The server does not support, or refuses to support, the HTTP protocol version that was used in the request message. The server is indicating that it is unable or unwilling to complete the request using the same major version as the client, as described in section 3.1, other than with this error message. The response SHOULD contain an entity describing why that version is not supported and what other protocols are supported by that server."),
  `506` = list('Variant Also Negotiates', 'The server has an internal configuration error: the chosen variant resource is configured to engage in transparent content negotiation itself, and is therefore not a proper end point in the negotiation process. RFC 2295', NULL),
  `507` = list('Insufficient Storage', 'The method could not be performed on the resource because the server is unable to store the representation needed to successfully complete the request. WebDAV; RFC 4918', NULL),
  `508` = list('Loop Detected', 'The server detected an infinite loop while processing the request. WebDAV; RFC 5842', NULL),
  `510` = list('Not Extended', 'Further extensions to the request are required for the server to fulfil it. RFC 2774', NULL),
  `511` = list('Network Authentication Required', 'The client needs to authenticate to gain network access. RFC 6585', NULL),
  `598` = list('Network read timeout error', 'Used by some HTTP proxies to signal a network read timeout behind the proxy to a client in front of the proxy', NULL),
  `599` = list('Network connect timeout error', 'Used by Microsoft HTTP proxies to signal a network connect timeout behind the proxy to a client in front of the proxy', NULL),
  # Apache
  `509` = list('Bandwidth Limit Exceeded (Apache)', 'Bandwidth Limit Exceeded', "The server has exceeded the bandwidth specified by the server administrator; this is often used by shared hosting providers to limit the bandwidth of customers."),
  # Nginx
  `444` = list('No Response (Nginx)', 'Used internally to instruct the server to return no information to the client and close the connection immediately.', NULL),
  `494` = list('Request header too large (Nginx)', 'Client sent too large request or too long header line.', NULL),
  `495` = list('SSL Certificate Error (Nginx)', 'An expansion of the 400 Bad Request response code, used when the client has provided an invalid client certificate.', NULL),
  `496` = list('SSL Certificate Required (Nginx)', 'An expansion of the 400 Bad Request response code, used when a client certificate is required but not provided.', NULL),
  `497` = list('HTTP Request Sent to HTTPS Port (Nginx)', 'An expansion of the 400 Bad Request response code, used when the client has made a HTTP request to a port listening for HTTPS requests', NULL),
  `499` = list('Client Closed Request (Nginx)', 'Client has closed the request before the server could send a response', NULL),
  # Cloudflare
  `520` = list('Web Server Returned an Unknown Error (Cloudflare)', 'The origin server returned an empty, unknown, or unexplained response to Cloudflare', NULL),
  `521` = list('Web Server Is Down (Cloudflare)', 'The origin server has refused the connection from Cloudflare', NULL),
  `522` = list('Connection Timed Out (Cloudflare)', 'Cloudflare could not negotiate a TCP handshake with the origin server', NULL),
  `523` = list('Origin Is Unreachable (Cloudflare)', 'Cloudflare could not reach the origin server; for example, if the DNS records for the origin server are incorrect', NULL),
  `524` = list('A Timeout Occurred (Cloudflare)', 'Cloudflare was able to complete a TCP connection to the origin server, but did not receive a timely HTTP response.', NULL),
  `525` = list('SSL Handshake Failed (Cloudflare)', 'Cloudflare could not negotiate a SSL/TLS handshake with the origin server', NULL),
  `526` = list('Invalid SSL Certificate (Cloudflare)', 'Cloudflare could not validate the SSL certificate on the origin web server', NULL),
  `527` = list('Railgun Error (Cloudflare)', 'Interrupted connection between Cloudflare and the origin servers Railgun serve', NULL)
)
