% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapping-functions.R
\name{mapping-functions}
\alias{mapping-functions}
\alias{mapping_functions}
\title{How to set cell properties variably by cell contents}
\description{
This help page explains how to set properties differently for cells,
depending on their contents.

For example, in a table of p-values, you could bold cells where p < 0.05:

\if{html}{\out{<div class="sourceCode">}}\preformatted{  map_bold(pval_hux, by_ranges(0.05, c(TRUE, FALSE)))
}\if{html}{\out{</div>}}

Or you can use red text for a particular value:

\if{html}{\out{<div class="sourceCode">}}\preformatted{  hxtbl \%>\% map_text_color(by_values("Warning" = "red"))
}\if{html}{\out{</div>}}

There is a \code{map_...} function for each huxtable cell property. The syntax is:

\if{html}{\out{<div class="sourceCode">}}\preformatted{  map_property(ht, row, col, fn)
}\if{html}{\out{</div>}}

where \code{property} is the property name.

\code{row} and \code{col} specify ranges of rows and columns. See \link{rowspecs} for
details. To set properties for the whole table, omit \code{row} and \code{col}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{  map_property(ht, fn)
}\if{html}{\out{</div>}}

The \code{fn} argument is a \emph{mapping function} which maps cell contents to
property values.
\itemize{
\item To set property values in "stripes" by rows or by columns, use \code{\link[=by_rows]{by_rows()}}
and \code{\link[=by_cols]{by_cols()}}.
\item To set property values for cells with specific contents, use \code{\link[=by_values]{by_values()}}.
\item To set property values for cells within a numeric range, use \code{\link[=by_ranges]{by_ranges()}}.
\item To set property values for cells by quantiles, use \code{\link[=by_quantiles]{by_quantiles()}} or
\code{\link[=by_equal_groups]{by_equal_groups()}}.
\item To set property values for cells that match a string or regular expression,
use \code{\link[=by_regex]{by_regex()}}.
\item To map numeric values to a colorspace, use \code{\link[=by_colorspace]{by_colorspace()}}.
\item For a more general solution, use \code{\link[=by_function]{by_function()}} or \code{\link[=by_cases]{by_cases()}}.
}
}
\section{Caveat}{


Most functions convert the huxtable to a matrix using \code{\link[=as.matrix]{as.matrix()}}. This can
have unexpected results if you mix character and numeric data. See the
example.
}

\section{Technical details}{


\code{fn} takes four arguments: the entire original huxtable
\code{ht}, a numeric vector of \code{rows}, a numeric vector of \code{cols}, and the
\code{current} property values for \code{ht[rows, cols]}, as a matrix. It should return
the new property values for \code{ht[rows, cols]}, as a matrix.
}

\examples{
ht <- hux(Condition = c("OK", "Warning", "Error"))
ht <- map_text_color(ht, by_values(
  OK      = "green",
  Warning = "orange",
  Error   = "red"
))
ht

# Leaving NA values alone:
map_text_color(ht, by_values(
  "OK" = "blue", NA, ignore_na = TRUE
))

# Resetting values:
map_text_color(ht, by_values(
  "OK" = "blue", NA, ignore_na = FALSE
))

ht <- as_hux(matrix(rnorm(15), 5, 3))
map_background_color(ht, by_ranges(
  c(-1, 1),
  c("blue", "yellow", "red")
))
map_background_color(
  ht,
  by_equal_groups(2, c("red", "green"))
)

ht <- hux(
  Coef = c(3.5, 2.4, 1.3),
  Pval = c(0.04, 0.01, 0.07),
  add_colnames = TRUE
)
map_bold(
  ht, everywhere, "Pval",
  by_ranges(0.05, c(TRUE, FALSE))
)

# Problems with as.matrix:

ht <- hux(c(-1, 1, 2), letters[1:3])
as.matrix(ht) # look at the spaces...
as.matrix(ht) > 0 # uh oh
map_text_color(
  ht,
  by_cases(. < 0 ~ "red", TRUE ~ "blue")
)

# To avoid this, only look at the truly numeric columns:
map_text_color(ht,
  row = 1:3, col = 1,
  by_cases(. < 0 ~ "red", TRUE ~ "blue")
)
}
