% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hwordcloud.R
\docType{package}
\name{hwordcloud}
\alias{hwordcloud}
\alias{hwordcloud-package}
\title{hwordcloud: Rendering word clouds using R + Highcharts}
\usage{
hwordcloud(text, size, width = "100\%", height = NULL,
  theme = "sandsignika", itermName = "count", title = "",
  titleAlign = "center", titleSize = "20px", titleColor = "#333333",
  subtitle = "", subtitleAlign = "center", subtitleSize = "",
  subtitleColor = "#666666")
}
\arguments{
\item{text}{character vector;}

\item{size}{numeric vector;}

\item{width}{chart width, for example, "100\%";}

\item{height}{chart height, for example, "400px";}

\item{theme}{chart theme, you can use these themes:
darkgreen/darkblue/avocado/darkunica/gray/
gridlight/grid/sandsignika/sunset;}

\item{itermName}{attribute in tooltip;}

\item{title}{title;}

\item{titleAlign}{title alignment, left/center/right;}

\item{titleSize}{title size, like "20px";}

\item{titleColor}{title color, like "#333333";}

\item{subtitle}{subtitle;}

\item{subtitleAlign}{subtitle alignment, left/center/right;}

\item{subtitleSize}{subtitle size, like "16px";}

\item{subtitleColor}{subtitle color, like "#666666"}
}
\description{
This function can create wordclouds by binding R and Highcharts.

Rendering word clouds using R + Highcharts
}
\section{\code{\link{hwordcloud}}}{
 Rendering word clouds using R + Highcharts
}

\examples{
library(hwordcloud)
library(wordcloud2)
df <- head(demoFreq, 50)
if(interactive()){
   hwordcloud(text = df$word, size = df$freq)
}

}
