% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutate.R
\name{combine_vars}
\alias{combine_vars}
\title{Combine variables into one categorical variable}
\usage{
combine_vars(
  data,
  vars,
  sep = ":",
  name = NULL,
  keep_empty = FALSE,
  keep_na = TRUE
)
}
\arguments{
\item{data}{a dataframe with the columns to be combined}

\item{vars}{a character vector of the variables to be combined}

\item{sep}{a character string to separate the levels}

\item{name}{a name for the new variable}

\item{keep_empty}{logical, if \code{FALSE} empty level combinations
are removed from the factor}

\item{keep_na}{logical, if \code{TRUE} the \code{<NA>} in the factors or
\code{NA} in the characters will turn in a level \code{"(Missing)"};
otherwise, the resulting entries will return \code{<NA>}}
}
\value{
original dataframe containing new columns of the new
        categorical variable with tidyverse code attached
}
\description{
Combine chosen variables of any class by concatenating
them into one factor variable, and returns the result
along with tidyverse code used to generate it.
}
\examples{
combined <- combine_vars(warpbreaks, vars = c("wool", "tension"), sep = "_")
cat(code(combined))
head(combined)

}
\author{
Owen Jin, Zhaoming Su
}
