% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutate.R
\name{transform_vars}
\alias{transform_vars}
\title{Transform data of numeric variables}
\usage{
transform_vars(data, vars, fn, names = NULL)
}
\arguments{
\item{data}{a dataframe with the variables to transform}

\item{vars}{a character of the numeric variables in \code{data} to transform}

\item{fn}{the name (a string) of a valid R function}

\item{names}{the names of the new variables}
}
\value{
the original dataframe containing the new columns of the transformed
        variable with tidyverse code attached
}
\description{
Transform the values of numeric variables by applying
a mathematical function
}
\examples{
transformed <- transform_vars(iris,
    var = "Petal.Length",
    fn = "log"
)
cat(code(transformed))
head(transformed)

}
\seealso{
\code{\link{code}}
}
\author{
Zhaoming Su
}
