% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ifcb_psd_plot.R
\name{ifcb_psd_plot}
\alias{ifcb_psd_plot}
\title{Generate PSD Plot for a Given Sample}
\usage{
ifcb_psd_plot(sample_name, data, fits, start_fit, flags = NULL)
}
\arguments{
\item{sample_name}{The name of the sample to plot in DYYYYMMDDTHHMMSS_IFCBXXX.}

\item{data}{A data frame containing the PSD data (data output from \code{ifcb_psd}), where each row represents a sample and each column represents different particle sizes in micrometers.}

\item{fits}{A data frame containing the fit parameters for the power curve (fits output from \code{ifcb_psd}), where each row represents a sample and the columns include the parameters \code{a}, \code{k}, and \code{R^2}.}

\item{start_fit}{The x-value threshold below which data should be excluded from the plot and fit.}

\item{flags}{Optional data frame or tibble with columns \code{sample} and \code{flag}. If \code{sample_name}
appears in \code{flags$sample}, the corresponding \code{flag} text will be displayed on the plot
as a red label in the top-left corner.}
}
\value{
A ggplot object representing the PSD plot for the sample.
}
\description{
This function generates a plot for a given sample from Particle Size Distribution (PSD) data and fits from Imaging FlowCytobot (IFCB).
The PSD \code{data} and \code{fits} can be generated by \code{ifcb_psd} (Hayashi et al. 2025).
}
\examples{
\dontrun{
# Initialize a python session if not already set up
ifcb_py_install()

# Analyze PSD
psd <- ifcb_psd(
  feature_folder = 'path/to/features',
  hdr_folder = 'path/to/hdr_data',
  save_data = TRUE,
  output_file = 'psd/svea_2021',
  plot_folder = NULL,
  use_marker = FALSE,
  start_fit = 13,
  r_sqr = 0.5
)

# Optional flags
flags <- tibble::tibble(
  sample = "D20230316T101514",
  flag   = "Incomplete Run."
)

# Plot PSD of the first sample
plot <- ifcb_psd_plot(
  sample_name = "D20230316T101514",
  data = psd$data,
  fits = psd$fits,
  start_fit = 10,
  flags = flags
)

# Inspect plot
print(plot)
}
}
\references{
Hayashi, K., Enslein, J., Lie, A., Smith, J., Kudela, R.M., 2025. Using particle size distribution (PSD)
to automate imaging flow cytobot (IFCB) data quality in coastal California, USA.
International Society for the Study of Harmful Algae. https://doi.org/10.15027/0002041270
}
\seealso{
\code{\link{ifcb_psd}} \url{https://github.com/kudelalab/PSD}
}
