% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pubs.R
\docType{data}
\name{pubs}
\alias{pubs}
\title{Publications of the INLPO}
\format{
An object of class 'pub' that inherits behavior from the 'data.frame' class
and includes the following columns:
\describe{
\item{\code{pub_id}}{Unique identifier for the publication.}
\item{\code{institution}}{Name of the institution that published and/or sponsored the report.}
\item{\code{type}}{Type of publication.}
\item{\code{text_ref}}{Text reference (also known as the in-text citation) that excludes the year of publication.}
\item{\code{year}}{Year of publication.}
\item{\code{author_id}}{Identifier(s) of the author(s),
referes to the primry key of the \code{\link{authors}} data table.}
\item{\code{title}}{Title of publication.}
\item{\code{bibentry}}{Bibliographic entry of class \code{\link[utils:bibentry]{bibentry}}.}
\item{\code{abstract}}{Abstract of publication.}
\item{\code{annotation}}{Annotation of publication.}
\item{\code{annotation_src}}{Identifier for the annotation source publication
(Knobel and others, 2005; Bartholomay, 2022).}
\item{\code{files}}{File names associated with the publication.}
}
}
\source{
Many of these publications are available through the
\href{https://pubs.usgs.gov/}{USGS Publications Warehouse}.
}
\usage{
pubs
}
\description{
Bibliographic information for reports, articles, maps, and theses related
to scientific monitoring and research conducted by the U.S. Geological Survey (USGS),
Idaho Water Science Center, Idaho National Laboratory Project Office (INLPO).
}
\examples{
# Subset Fisher and others (2012) and display structure:
id <- "FisherOthers2012"
pub <- pubs[id, ]
str(pub, max.level = 3, width = 75, strict.width = "cut")

# Print suggested citation:
attr(unclass(pub$bibentry[[1]])[[1]], which = "textVersion")

# Print authors full name:
format(pub$bibentry[[1]]$author, include = c("given", "family"))

# Print abstract:
pub$abstract
}
\references{
Bartholomay, R.C., 2022, Historical development of the U.S. Geological Survey
hydrological monitoring and investigative programs at the Idaho National Laboratory, Idaho, 2002-2020:
U.S. Geological Survey Open-File Report 2022-1027 (DOE/ID-22256), 54 p., \doi{10.3133/ofr20221027}.

Knobel, L.L., Bartholomay, R.C., and Rousseau, J.P., 2005,
Historical development of the U.S. Geological Survey hydrologic monitoring and investigative programs
at the Idaho National Engineering and Environmental Laboratory, Idaho, 1949 to 2001:
U.S. Geological Survey Open-File Report 2005--1223 (DOE/ID--22195), 93 p.,
\doi{10.3133/ofr20051223}.
}
\keyword{datasets}
