% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outputFunctions.R
\name{igToPDF}
\alias{igToPDF}
\title{Exports Interaction graph to a PDF file}
\usage{
igToPDF(ig, path = "", fName = "InteractionGraph", h = 2000)
}
\arguments{
\item{ig}{Interaction graph}

\item{path}{The folder in which to write the PDF file;}

\item{fName}{The name of the file to be created; "InteractionGraph" by
default}

\item{h}{Desired height of the image in pixels; 2000px by default}
}
\value{
Writes the \code{ig} interaction graph to a PDF (\code{.pdf}) file
  to the folder specified in the \code{path}
}
\description{
Exports Interaction graph to a PDF file
}
\examples{
#create temp dir path with slashes
myDir <- gsub("\\\\\\\\", "/", tempdir())

#create interaction graph
g <- interactionGraph(golf, "Play", intNo = 10)

#write to PDF
igToPDF(g, path = myDir, fName = "MyGraph", h = 2000)
}
