% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intrinsicKappa.R
\name{intrinsicKappa}
\alias{intrinsicKappa}
\title{Intrinsic Kappa}
\usage{
intrinsicKappa(M, alpha = 0.05, alpha_adjusted = TRUE)
}
\arguments{
\item{M}{matrix to be assessed}

\item{alpha}{one-sided significance level}

\item{alpha_adjusted}{logical, whether the significance level shall be adjusted}
}
\value{
Intrinsic kappa value
}
\description{
Intrinsic Kappa
}
\details{
Computation of intrinsic kappa with a dichotomous response and known relation of the
input frequencies.
}
\examples{
M <- matrix(c(2375, 25, 10, 2390), ncol = 2)
rownames(M) <- c('ok-rating', 'nok-rating')
colnames(M) <- c('ok-standard', 'nok-standard')
alpha <- 0.05
alpha_adjusted <- FALSE
intrinsicKappa(M, alpha, alpha_adjusted)

}
\references{
R. Sanchez-Marquez, F. Gerhorst and D. Schindler (2023)
"Effectiveness of quality inspections of attributive characteristics – A novel and practical method for estimating the “intrinsic”
value of kappa based on alpha and beta statistics." Computers & Industrial Engineering, 109006.
}
