% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/invictor.R
\name{trimmers}
\alias{trimmers}
\alias{\%[-\%}
\alias{\%-]\%}
\alias{\%[-]\%}
\title{Trim vector by index}
\usage{
x \%[-\% i

x \%-]\% i

x \%[-]\% j
}
\arguments{
\item{x}{A vector}

\item{i}{A 1 element vector by which the rear of \code{x} will be trimmed}

\item{j}{A one, or two element numeric vector. One element: Trim front by \code{floor(i/2)} and rear by \code{ceiling(i/2)}. Two elements: Trim \code{i[1]} from the front and \code{i[2]} from the rear.}
}
\value{
A trimmed version of \code{x}
}
\description{
Trim vector by index

Trim vector front

Trim vector rear

Trim vector front + rear
}
\examples{

x <- rnorm(100)

# Trim front
x\%[-\%5

# Trim rear
x\%-]\%5

# Trim front + rear
x\%[-]\%c(2,10)

x\%[-]\%7

}
