% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esprima.R
\name{esprima}
\alias{esprima}
\alias{esprima_tokenize}
\alias{esprima_parse}
\title{JavaScrip Syntax Tree}
\usage{
esprima_tokenize(text, range = FALSE, loc = FALSE, comment = FALSE)

esprima_parse(text, jsx = FALSE, range = FALSE, loc = FALSE,
  tolerant = FALSE, tokens = FALSE, comment = FALSE)
}
\arguments{
\item{text}{a character vector with JavaScript code}

\item{range}{Annotate each token with its zero-based start and end location}

\item{loc}{Annotate each token with its column and row-based location}

\item{comment}{Include every line and block comment in the output}

\item{jsx}{Support JSX syntax}

\item{tolerant}{Tolerate a few cases of syntax errors}

\item{tokens}{Collect every token}
}
\description{
\href{https://www.npmjs.com/package/esprima}{Esprima} is a high performance, standard-compliant
ECMAScript parser. It has full support for ECMAScript 2017 and returns a sensible syntax tree
format as standardized by ESTree project.
}
\details{
The \code{esprima_tokenize} function returns a data frame with JavaScript tokens. The
\code{esprima_parse} function returns the Syntax Tree in JSON format. This can be parsed to R
using e.g. \code{jsonlite::fromJSON}.
}
\examples{
code <- "function test(x, y){ x = x || 1; y = y || 1; return x*y;}"
esprima_tokenize(code)
esprima_parse(code)
}
\references{
Esprima documentation: \url{http://esprima.readthedocs.io/en/4.0/}.
}
