% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ebalance.R
\name{ebalance_custom}
\alias{ebalance_custom}
\title{Modified version of ebalance (originally from Jens Hainmueller)}
\usage{
ebalance_custom(
  Treatment,
  X,
  base.weight = NULL,
  norm.constant = NULL,
  coefs = NULL,
  max.iterations = 200,
  constraint.tolerance = 0.001,
  print.level = 0
)
}
\arguments{
\item{Treatment}{a numeric vector of length equal to the total number of units where treated (population) units take a value of 1 and control (sampled) units take a value of 0.}

\item{X}{matrix of data where rows are observations and columns are covariates.}

\item{base.weight}{an optional numeric vector argument of length equal to the total number of control units to specify the base weight of each control unit within entropy balancing. Default is even weights (1) for all controls.}

\item{norm.constant}{an optional numeric argument; users should leave unspecified in most cases.}

\item{coefs}{an optional vector argument of length equal to one more than the number of covariates in \code{X}; users should leave unspecified in most cases.}

\item{max.iterations}{numeric maximum number of iterations to use when searching for weights}

\item{constraint.tolerance}{numeric tolerance level.}

\item{print.level}{a numeric argument to specify the amount of information printed out. 0 is silent, 1 prints convergence status, 2 prints maximum deviance per iteration, 3 prints loss and step length.}
}
\value{
\item{target.margins}{Column sums of \code{X} among the treated units.}
\item{co.xdata}{Covariate matrix for the controls only built from \code{X} with an additional appended column of ones.}
\item{w}{weights found using ebalance. Note that treated units all receive flat weights of 1}
\item{maxdiff}{absolute value of the largest component of the gradient in the last iteration.}
\item{norm.constant}{norm constant used}
\item{constraint.tolerance}{tolerance used to evaluate convergence}
\item{max.iterations}{max iterations used}
\item{base.weight}{base weights used}
\item{print.level}{print level used}
\item{converged}{Convergence status. If ebalance failed to find weights within the specified \code{constraint.tolerance} after \code{max.iterations} this is \code{FALSE}. Note that even if ebalance does not converge, the last iteration's weights \code{w} are returned.}
}
\description{
This is a custom version of the \code{ebal} (entropy balancing) package by Jens Hainmueller.  Chooses weights on controls to make
covariate means equal to those of treated. This version differs from \code{ebal} only in that it handles
cases where there is only a single unit, which otherwise causes a problem in the original code.
}
